﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_Task.h>

namespace nnt { namespace ens {

/**
 * @brief   巨大なサイズのタスク
 *
 * @details
 *  本タスクは巨大なバッファをメンバーに保持しており、タスク作成時に巨大なメモリを確保します。
 */
class TaskLargeSize : public nn::ens::detail::core::Task
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskLargeSize() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~TaskLargeSize() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   span    待機期間
     *
     * @details
     */
    void SetParameter(nn::TimeSpan span) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Bit8 m_LargeBuffer[128 * 1024];
    //
    nn::TimeSpan m_Span;

private:
    //
    nn::Result StepWait() NN_NOEXCEPT;
};

}}
