﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testEns_Common.h"

/*
    ■ 継承図
    Base(RTTI) +- A1(RTTI) -- A2(RTTI) -- A3(RTTI) -- AX (NO-RTTI) -- AY(NO-RTTI)
               +- B1(RTTI) -- B2(RTTI) -- B3(RTTI)
               +- C1(NO-RTTI) -- C2(RTTI) -- C3(NO-RTTI)
               +- D1(NO-RTTI)
*/

namespace
{
    class DynamicCastBase
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO_ROOT(DynamicCastBase);

    public:
        virtual const char* GetString() const NN_NOEXCEPT
        {
            return "Base";
        }
    };

    class DynamicCastDerivedA1 : public DynamicCastBase
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedA1, DynamicCastBase);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedA1";
        }
    };

    class DynamicCastDerivedA2 : public DynamicCastDerivedA1
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedA2, DynamicCastDerivedA1);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedA2";
        }
    };

    class DynamicCastDerivedA3 : public DynamicCastDerivedA2
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedA3, DynamicCastDerivedA2);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedA3";
        }
    };

    class DynamicCastDerivedAX : public DynamicCastDerivedA3
    {
    public:
        // NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedAX, DynamicCastDerivedA3);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedAX";
        }
    };

    class DynamicCastDerivedAY : public DynamicCastDerivedAX
    {
    public:
        // NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedAY, DynamicCastDerivedAX);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedAY";
        }
    };

    class DynamicCastDerivedB1 : public DynamicCastBase
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedB1, DynamicCastBase);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedB1";
        }
    };

    class DynamicCastDerivedB2 : public DynamicCastDerivedB1
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedB2, DynamicCastDerivedB1);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedB2";
        }
    };

    class DynamicCastDerivedB3 : public DynamicCastDerivedB2
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedB3, DynamicCastDerivedB2);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedB3";
        }
    };

    class DynamicCastDerivedC1 : public DynamicCastBase
    {
    public:
        // NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedC1, DynamicCastBase);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedC1";
        }
    };

    class DynamicCastDerivedC2 : public DynamicCastDerivedC1
    {
    public:
        NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedC2, DynamicCastDerivedC1);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedC2";
        }
    };

    class DynamicCastDerivedC3 : public DynamicCastDerivedC2
    {
    public:
        // NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedC3, DynamicCastDerivedC2);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedC3";
        }
    };

    class DynamicCastDerivedD1 : public DynamicCastBase
    {
    public:
        // NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO(DynamicCastDerivedD1, DynamicCastBase);

    public:
        virtual const char* GetString() const NN_NOEXCEPT NN_OVERRIDE
        {
            return "DerivedD1";
        }
    };
}

namespace
{
    bool CastToBase(DynamicCastBase* pBase) NN_NOEXCEPT
    {
        DynamicCastBase* p = nn::ens::detail::DynamicCast<DynamicCastBase*>(pBase);
        return (p != nullptr);
    }

    bool CastToDerivedA1(DynamicCastBase* pBase) NN_NOEXCEPT
    {
        DynamicCastDerivedA1* p = nn::ens::detail::DynamicCast<DynamicCastDerivedA1*>(pBase);
        return (p != nullptr);
    }

    bool CastToDerivedA2(DynamicCastBase* pBase) NN_NOEXCEPT
    {
        DynamicCastDerivedA2* p = nn::ens::detail::DynamicCast<DynamicCastDerivedA2*>(pBase);
        return (p != nullptr);
    }

    bool CastToDerivedB1(DynamicCastBase* pBase) NN_NOEXCEPT
    {
        DynamicCastDerivedB1* p = nn::ens::detail::DynamicCast<DynamicCastDerivedB1*>(pBase);
        return (p != nullptr);
    }

    bool CastToDerivedB2(DynamicCastBase* pBase) NN_NOEXCEPT
    {
        DynamicCastDerivedB2* p = nn::ens::detail::DynamicCast<DynamicCastDerivedB2*>(pBase);
        return (p != nullptr);
    }

    bool CastToDerivedC2(DynamicCastBase* pBase) NN_NOEXCEPT
    {
        DynamicCastDerivedC2* p = nn::ens::detail::DynamicCast<DynamicCastDerivedC2*>(pBase);
        return (p != nullptr);
    }
}

TEST(EnsDynamicCast, Cast)
{
    DynamicCastBase base;
    DynamicCastDerivedA1 derivedA1;
    DynamicCastDerivedA2 derivedA2;
    DynamicCastDerivedA3 derivedA3;
    DynamicCastDerivedB1 derivedB1;
    DynamicCastDerivedB2 derivedB2;
    DynamicCastDerivedB3 derivedB3;

    EXPECT_TRUE(CastToBase(&base));
    EXPECT_TRUE(CastToBase(&derivedA1));
    EXPECT_TRUE(CastToBase(&derivedA2));
    EXPECT_TRUE(CastToBase(&derivedA3));
    EXPECT_TRUE(CastToBase(&derivedB1));
    EXPECT_TRUE(CastToBase(&derivedB2));
    EXPECT_TRUE(CastToBase(&derivedB3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&base)->GetString(), "Base");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedA1)->GetString(), "DerivedA1");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedA2)->GetString(), "DerivedA2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedA3)->GetString(), "DerivedA3");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedB1)->GetString(), "DerivedB1");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedB2)->GetString(), "DerivedB2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedB3)->GetString(), "DerivedB3");

    EXPECT_TRUE(CastToDerivedA1(&derivedA1));
    EXPECT_TRUE(CastToDerivedA1(&derivedA2));
    EXPECT_TRUE(CastToDerivedA1(&derivedA3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA1*>(&derivedA1)->GetString(), "DerivedA1");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA1*>(&derivedA2)->GetString(), "DerivedA2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA1*>(&derivedA3)->GetString(), "DerivedA3");

    EXPECT_FALSE(CastToDerivedA1(&base));
    EXPECT_FALSE(CastToDerivedA1(&derivedB1));
    EXPECT_FALSE(CastToDerivedA1(&derivedB2));
    EXPECT_FALSE(CastToDerivedA1(&derivedB3));

    EXPECT_TRUE(CastToDerivedA2(&derivedA2));
    EXPECT_TRUE(CastToDerivedA2(&derivedA3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA2*>(&derivedA2)->GetString(), "DerivedA2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA2*>(&derivedA3)->GetString(), "DerivedA3");

    EXPECT_FALSE(CastToDerivedA2(&base));
    EXPECT_FALSE(CastToDerivedA2(&derivedA1));
    EXPECT_FALSE(CastToDerivedA2(&derivedB1));
    EXPECT_FALSE(CastToDerivedA2(&derivedB2));
    EXPECT_FALSE(CastToDerivedA2(&derivedB3));

    EXPECT_TRUE(CastToDerivedB1(&derivedB1));
    EXPECT_TRUE(CastToDerivedB1(&derivedB2));
    EXPECT_TRUE(CastToDerivedB1(&derivedB3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedB1*>(&derivedB1)->GetString(), "DerivedB1");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedB1*>(&derivedB2)->GetString(), "DerivedB2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedB1*>(&derivedB3)->GetString(), "DerivedB3");

    EXPECT_FALSE(CastToDerivedB1(&base));
    EXPECT_FALSE(CastToDerivedB1(&derivedA1));
    EXPECT_FALSE(CastToDerivedB1(&derivedA2));
    EXPECT_FALSE(CastToDerivedB1(&derivedA3));

    EXPECT_TRUE(CastToDerivedB2(&derivedB2));
    EXPECT_TRUE(CastToDerivedB2(&derivedB3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedB2*>(&derivedB2)->GetString(), "DerivedB2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedB2*>(&derivedB3)->GetString(), "DerivedB3");

    EXPECT_FALSE(CastToDerivedB2(&base));
    EXPECT_FALSE(CastToDerivedB2(&derivedA1));
    EXPECT_FALSE(CastToDerivedB2(&derivedA2));
    EXPECT_FALSE(CastToDerivedB2(&derivedA3));
    EXPECT_FALSE(CastToDerivedB2(&derivedB1));
}

TEST(EnsDynamicCast, Mixed)
{
    DynamicCastBase base;
    DynamicCastDerivedC1 derivedC1;
    DynamicCastDerivedC2 derivedC2;
    DynamicCastDerivedC3 derivedC3;

    EXPECT_TRUE(CastToBase(&base));
    EXPECT_TRUE(CastToBase(&derivedC1));
    EXPECT_TRUE(CastToBase(&derivedC2));
    EXPECT_TRUE(CastToBase(&derivedC3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&base)->GetString(), "Base");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedC1)->GetString(), "DerivedC1");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedC2)->GetString(), "DerivedC2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedC3)->GetString(), "DerivedC3");

    // コンパイル不可
    // EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedC1*>(&derivedC1)->GetString(), "DerivedC1");
    // EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedC1*>(&derivedC2)->GetString(), "DerivedC2");
    // EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedC1*>(&derivedC3)->GetString(), "DerivedC3");

    EXPECT_TRUE(CastToDerivedC2(&derivedC2));
    EXPECT_TRUE(CastToDerivedC2(&derivedC3));
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedC2*>(&derivedC2)->GetString(), "DerivedC2");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedC2*>(&derivedC3)->GetString(), "DerivedC3");

    EXPECT_FALSE(CastToDerivedC2(&base));
    EXPECT_FALSE(CastToDerivedC2(&derivedC1));

    // コンパイル不可
    // EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedC1*>(&derivedC3)->GetString(), "DerivedC3");
}

TEST(EnsDynamicCast, NotDefinition1)
{
    DynamicCastDerivedAX derivedAX;
    DynamicCastDerivedAY derivedAY;

    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedAX)->GetString(), "DerivedAX");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA1*>(&derivedAX)->GetString(), "DerivedAX");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA2*>(&derivedAX)->GetString(), "DerivedAX");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA3*>(&derivedAX)->GetString(), "DerivedAX");

    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedAY)->GetString(), "DerivedAY");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA1*>(&derivedAY)->GetString(), "DerivedAY");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA2*>(&derivedAY)->GetString(), "DerivedAY");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastDerivedA3*>(&derivedAY)->GetString(), "DerivedAY");

#if 0

    // AX と AY は NN_DETAIL_ENS_DEFINE_RUNTIME_TYPEINFO をしていないのでコンパイルは通らない。
    DynamicCastBase base;
    nn::ens::detail::DynamicCast<DynamicCastDerivedAX*>(&base);
    nn::ens::detail::DynamicCast<DynamicCastDerivedAY*>(&base);
    nn::ens::detail::DynamicCast<DynamicCastDerivedAX*>(&derivedAX);
    nn::ens::detail::DynamicCast<DynamicCastDerivedAY*>(&derivedAY);

#endif
}

TEST(EnsDynamicCast, NotDefinition2)
{
    DynamicCastDerivedC1 derivedC1;
    DynamicCastDerivedD1 derivedD1;

    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedC1)->GetString(), "DerivedC1");
    EXPECT_STREQ(nn::ens::detail::DynamicCast<DynamicCastBase*>(&derivedD1)->GetString(), "DerivedD1");

    // DynamicCast 内の NN_STATIC_ASSERT がない場合、以下のテストは成功してしまう。
    // EXPECT_NE(nn::ens::detail::DynamicCast<DynamicCastDerivedD1*>(static_cast<DynamicCastBase*>(&derivedC1)), nullptr);
}
