﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/ens_TypesForAcbaa.h>
#include <nn/ens/ens_AsyncContext.h>

namespace nnt { namespace ens {

/**
 * @brief   メッセージのメタデータフィクスチャを取得します。
 *
 * @param[out]  pOutContext     非同期コンテキスト
 * @param[out]  pOutMetadata    メタデータフィクスチャ（非同期処理成功後に取得可能）
 *
 * @pre
 *  - pOutContext != nullptr
 *  - pOutCredential != nullptr
 *
 * @details
 *  メッセージのメタデータフィクスチャを取得します。
 *
 *  メタデータフィクスチャとは、サーバー上で行われるメタデータの検査が必ず成功することを保証しているメタデータです。
 *
 *  メタデータはアプリケーションの要求に合わせてフォーマットや必須パラメータが更新されます。@n
 *  メタデータフィクスチャを使用することで、テストプログラムをフォーマット変更に追従させる必要がなくなります。
 */
void GetMessageMetadataFixture(nn::ens::AsyncContext* pOutContext, nn::ens::ReceiveBuffer* pOutMetadata) NN_NOEXCEPT;

/**
 * @brief   マイデザインのメタデータフィクスチャを取得します。
 *
 * @param[out]  pOutContext     非同期コンテキスト
 * @param[out]  pOutMetadata    メタデータフィクスチャ（非同期処理成功後に取得可能）
 * @param[in]   pDesignName     作品名
 *
 * @pre
 *  - pOutContext != nullptr
 *  - pOutCredential != nullptr
 *
 * @details
 *  マイデザインのメタデータフィクスチャを取得します。
 *
 *  メタデータフィクスチャとは、サーバー上で行われるメタデータの検査が必ず成功することを保証しているメタデータです。
 *
 *  メタデータはアプリケーションの要求に合わせてフォーマットや必須パラメータが更新されます。@n
 *  メタデータフィクスチャを使用することで、テストプログラムをフォーマット変更に追従させる必要がなくなります。
 *
 *  作品名に nullptr を指定した場合、サーバー定義のデフォルト値が設定されます。
 */
void GetMyDesignMetadataFixture(nn::ens::AsyncContext* pOutContext, nn::ens::ReceiveBuffer* pOutMetadata,
    const char* pDesignName) NN_NOEXCEPT;

}}
