require "sinatra"
require 'sinatra/reloader'
require 'msgpack'

$user_incremental_id = 0
$users = []

post '/api/v1/users' do

    if request.env["HTTP_AUTHORIZATION"] == "Bearer invalid" then
        status 401
        return getErrorResponse("lib", "4001")
    end

    $user_incremental_id = $user_incremental_id + 1
    $users.push $user_incremental_id

    response =
    {
        id: $user_incremental_id,
        password: "1234567890123456789012345678901234567890123456789012345678901234"
    }

    status 201
    response.to_msgpack

end

post '/api/v1/auth_token' do

    credential = MessagePack.unpack request.body.read

    user_id = nil

    for user in $users do
        if user == credential["id"] then
            user_id = user
            break
        end
    end

    if user_id == nil then
        status 404
        return getErrorResponse("lib", "3005")
    end

    if credential["password"] != "1234567890123456789012345678901234567890123456789012345678901234" then
        status 401
        return getErrorResponse("lib", "4201")
    end

    # F؃g[NɃ[U[ ID 𒼐ړB
    response =
    {
        token: credential["id"].to_s,
        expire_at: 4102444799
    }

    status 201
    response.to_msgpack

end

post '/api/v1/reports' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    response =
    {
        report_id: SecureRandom.uuid
    }

    status 201
    response.to_msgpack

end

def getRequestUserId(request)

    # Authorization wb_[ "Bearer <user_id>" ƂȂ͂B
    request.env["HTTP_AUTHORIZATION"].slice(7..-1).to_i

end

def getErrorResponse(category, code)

    response =
    {
        category: category,
        code: code
    }

    response.to_msgpack

end
