require "sinatra"
require 'sinatra/reloader'
require 'msgpack'
require 'date'
require 'securerandom'
require './ens_Basic.rb'

DesignStatus =
{
    available: 0,
    deleted: 1
}.freeze

$message_card_incremental_id = 0
$message_cards = []

$official_message_card_incremental_id = 0

$design_player_incremental_id = 0
$design_players = []

$design_incremental_id = 0
$designs = []

post '/api/v1/notification_tokens' do

    status 201

end

post '/api/v1/message_cards' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    request_body = MessagePack.unpack request.body.read

    $message_card_incremental_id = $message_card_incremental_id + 1

    message_card =
    {
        id: $message_card_incremental_id,
        sender: user_id,
        sent_at: Time.now.to_i,
        data: request_body
    }

    # Mɂ邽߁AɒǉB
    $message_cards.push message_card

    response =
    {
        id: message_card[:id]
    }

    status 201
    response.to_msgpack

end

post '/api/v1/message_cards/delete' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    request_body = MessagePack.unpack request.body.read

    if !(request_body["reason"] == "RECEIVED" || request_body["reason"] == "REJECTED") then
        status 400
        return getErrorResponse("lib", "3002")
    end

    for id in request_body["id_list"] do
        for message_card in $message_cards do
            if message_card[:id] == id then
                if message_card[:data]["target_id"] == user_id then
                    $message_cards.delete(message_card)
                end
                break
            end
        end
    end

    status 200

end

get '/api/v1/message_cards' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    offset = request.params["offset"].to_i
    count = request.params["limit"].to_i

    headers = []
    total = 0

    for message_card in $message_cards do
        if message_card[:data]["target_id"] == user_id then
            if total >= offset and headers.length < count then
                if message_card[:data]["meta"] != nil then
                    header =
                    {
                        id: message_card[:id],
                        user_id: message_card[:sender],
                        sent_at: message_card[:sent_at],
                        digest: SecureRandom.hex(20),
                        meta: message_card[:data]["meta"]
                    }
                    headers.push header
                else
                    header =
                    {
                        id: message_card[:id],
                        user_id: message_card[:sender],
                        sent_at: message_card[:sent_at],
                        digest: SecureRandom.hex(20)
                    }
                    headers.push header
                end
            end
            total = total + 1
        end
    end

    response =
    {
        offset: offset,
        count: headers.length,
        total: total,
        headers: headers
    }

    status 200
    response.to_msgpack

end

get '/api/v1/message_cards/:id' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    message_card_id = "#{params[:id]}".to_i

    response = nil

    for message_card in $message_cards do
        if message_card[:id] == message_card_id then
            if message_card[:data]["target_id"] == user_id then
                response =
                {
                    id: message_card[:id],
                    body: message_card[:data]["body"]
                }
                break
            end
        end
    end

    if response == nil then
        status 404
        return getErrorResponse("lib", "3005")
    end

    status 200
    response.to_msgpack

end

get '/api/v1/fixtures/message_cards' do

    response =
    {
        version: 0
    }

    status 200
    return response.to_msgpack

end

post '/api/v1/official_message_cards' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    $official_message_card_incremental_id = $official_message_card_incremental_id + 1

    response =
    {
        id: $official_message_card_incremental_id
    }

    status 201
    response.to_msgpack

end

post '/api/v1/design_players' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    request_body = MessagePack.unpack request.body.read

    $design_player_incremental_id = $design_player_incremental_id + 1

    id = 0
    found = false

    for design_player in $design_players do
        if design_player[:user_id] == user_id then
            id = design_player[:id]
            found = true
            break
        end
    end

    if found == false then
        design_player =
        {
            id: $design_player_incremental_id,
            user_id: user_id,
            name: request_body["name"]
        }

        $design_players.push design_player

        id = design_player[:id]
    end

    response =
    {
        id: id
    }

    status 201
    response.to_msgpack

end

post '/api/v1/designs' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    design_player_id = nil
    design_player_name = nil

    for design_player in $design_players do
        if design_player[:user_id] == user_id then
            design_player_id = design_player[:id]
            design_player_name = design_player[:name]
            break
        end
    end

    if design_player_id == nil then
        status 403
        return getErrorResponse("app", "1001")
    end

    request_body = MessagePack.unpack request.body.read

    $design_incremental_id = $design_incremental_id + 1

    design =
    {
        id: $design_incremental_id,
        user_id: user_id,
        design_player_id: design_player_id,
        design_player_name: design_player_name,
        updated_at: Time.now.to_i,
        data: request_body,
        status: DesignStatus[:available]
    }

    # Vɂ邽߁A擪ɒǉB
    $designs.unshift design

    response =
    {
        id: design[:id]
    }

    status 201
    response.to_msgpack

end

get '/api/v1/designs' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    design_player_id = request.params["design_player_id"].to_i
    offset = request.params["offset"].to_i
    count = request.params["limit"].to_i

    headers = []
    total = 0

    for design in $designs do
        if design[:status] == DesignStatus[:available] &&
            (design_player_id == 0 || design[:design_player_id] == design_player_id) then
            if total >= offset and headers.length < count then
                if design[:data]["meta"] != nil then
                    header =
                    {
                        id: design[:id],
                        design_player_name: design[:design_player_name],
                        updated_at: design[:updated_at],
                        digest: SecureRandom.hex(20),
                        meta: design[:data]["meta"]
                    }
                    headers.push header
                else
                    header =
                    {
                        id: design[:id],
                        design_player_name: design[:design_player_name],
                        updated_at: design[:updated_at],
                        digest: SecureRandom.hex(20)
                    }
                    headers.push header
                end
            end
            total = total + 1
        end
    end

    response =
    {
        offset: offset,
        count: headers.length,
        total: total,
        headers: headers
    }

    status 200
    response.to_msgpack

end

get '/api/v1/designs/:id' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    design_id = "#{params[:id]}".to_i

    response = nil

    for design in $designs do
        if design[:status] == DesignStatus[:available] && design[:id] == design_id then
            response =
            {
                id: design[:id],
                body: design[:data]["body"]
            }
            break
        end
    end

    if response == nil then
        # TODO: ȃG[X|XԂB
        status 500
        return getErrorResponse("lib", "3999")
    end

    status 200
    response.to_msgpack

end

delete '/api/v1/designs/:id' do

    user_id = getRequestUserId(request)

    if user_id == 0 then
        status 401
        return getErrorResponse("lib", "4101")
    end

    design_id = "#{params[:id]}".to_i

    for design in $designs do
        if design[:id] == design_id then
            if design[:user_id] == user_id then
                design[:status] = DesignStatus[:deleted]
            else
                status 404
                return getErrorResponse("lib", "3005")
            end
            break
        end
    end

    status 204

end

get '/api/v1/fixtures/designs' do

    response =
    {
        version: 0
    }

    status 200
    return response.to_msgpack

end
