﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "SetupGraphics.h"
#include <cstdlib>
#include <cstring>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/os.h>
#include <nn/fs.h>
#include <nn/init.h>
#include <nn/vi.h>
#include <nn/gfx.h>
#include <nn/image/image_JpegDecoder.h>
#include <nn/util/util_ScopeExit.h>

#if NN_GFX_IS_TARGET_NVN
    #include <nvn/nvn.h>
    #include <nvn/nvn_FuncPtrInline.h>
#endif

namespace nns {

class SetupGraphics::SetupGraphicsImpl
{
public:
    nn::vi::Display* m_pDisplay;
    nn::gfx::Device m_Device;
    nn::vi::Layer* m_pLayer;
    void InitializeLayer() NN_NOEXCEPT;
    void InitializeDevice() NN_NOEXCEPT;
};

NN_IMPLICIT SetupGraphics::SetupGraphics() NN_NOEXCEPT
:
m_Impl(new SetupGraphics::SetupGraphicsImpl())
{
    nn::vi::Initialize();
    m_Impl->InitializeLayer();
    m_Impl->InitializeDevice();
    nn::gfx::Initialize();
}

SetupGraphics::~SetupGraphics() NN_NOEXCEPT
{
    m_Impl->m_Device.Finalize();
    nn::gfx::Finalize();

    nn::vi::DestroyLayer(m_Impl->m_pLayer);
    nn::vi::CloseDisplay(m_Impl->m_pDisplay);
    nn::vi::Finalize();
}

nn::gfx::Device* SetupGraphics::GetDevice() NN_NOEXCEPT
{
    return &m_Impl->m_Device;
}

nn::vi::Display* SetupGraphics::GetDisplay() NN_NOEXCEPT
{
    return m_Impl->m_pDisplay;
}

nn::vi::Layer* SetupGraphics::GetLayer() NN_NOEXCEPT
{
    return m_Impl->m_pLayer;
}

// レイヤを初期化
void SetupGraphics::SetupGraphicsImpl::InitializeLayer()
{
    nn::Result result = nn::vi::OpenDefaultDisplay( &m_pDisplay );
    NN_ASSERT( result.IsSuccess() );
    NN_UNUSED( result );

    result = nn::vi::CreateLayer( &m_pLayer, m_pDisplay );
    NN_ASSERT( result.IsSuccess() );

    result = nn::vi::SetLayerScalingMode( m_pLayer, nn::vi::ScalingMode_FitToLayer );
    NN_ASSERT( result.IsSuccess() );
}

// デバイスを初期化
void SetupGraphics::SetupGraphicsImpl::InitializeDevice()
{
    nn::gfx::Device::InfoType info;
    info.SetDefault();
    info.SetApiVersion( nn::gfx::ApiMajorVersion, nn::gfx::ApiMinorVersion );
    m_Device.Initialize( info );
}

} // nns
