﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/audio.h>

namespace nns { namespace audio {

const int ChannelCountMax = 8;

void InitializeAudioRenderer(int channels) NN_NOEXCEPT;
void SetWaveFile(const char* waveFile, int channelIndex) NN_NOEXCEPT;
void StartAudioRenderer() NN_NOEXCEPT;
void FinalizeAudioRenderer() NN_NOEXCEPT;
bool IsInitialized() NN_NOEXCEPT;
bool IsMute() NN_NOEXCEPT;
void MuteAudio(bool isEnabled) NN_NOEXCEPT;

}} // nns::audio
