﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <vector>
#include <nn/vi/vi_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include "master/detail/visrv_SingleDisplayStrategy.h"
#include "testDisplay_MockPhysicalDisplay.h"

typedef std::vector<nn::visrv::master::detail::IPhysicalDisplay*> DisplayList;

TEST(SingleDisplayStrategy, GetDisplay_Any)
{
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::SingleDisplayStrategy strategy(&hdmi);

    EXPECT_EQ(&hdmi, strategy.GetDisplay());
}

TEST(SingleDisplayStrategy, Visit_Any)
{
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::SingleDisplayStrategy strategy(&hdmi);

    DisplayList displays;

    NNT_EXPECT_RESULT_SUCCESS(
        strategy.Visit(
            [](nn::visrv::master::detail::IPhysicalDisplay* display, void* userData) -> nn::Result
            {
                static_cast<DisplayList*>(userData)->push_back(display);
                return nn::ResultSuccess();
            },
            &displays
        )
    );

    ASSERT_EQ(1, displays.size());
    EXPECT_EQ(&hdmi, displays[0]);
}

TEST(SingleDisplayStrategy, Visit_ResultPropagation_Any)
{
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::SingleDisplayStrategy strategy(&hdmi);

    DisplayList displays;

    NNT_EXPECT_RESULT_FAILURE(
        nn::vi::ResultOperationFailed,
        strategy.Visit(
            [](nn::visrv::master::detail::IPhysicalDisplay* display, void* userData) -> nn::Result
            {
                static_cast<DisplayList*>(userData)->push_back(display);
                NN_RESULT_THROW(nn::vi::ResultOperationFailed());
            },
            &displays
        )
    );

    ASSERT_EQ(1, displays.size());
    EXPECT_EQ(&hdmi, displays[0]);
}
