﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "master/detail/visrv_IModeFilter.h"

class MockFilter : public nn::visrv::master::detail::IModeFilter
{
public:
    MockFilter() NN_NOEXCEPT;

    void Reset() NN_NOEXCEPT;
    bool IsFilterUsed() const NN_NOEXCEPT;
    void SetFilterResult(bool isValid) NN_NOEXCEPT;

    virtual bool IsValid(const nn::vi::DisplayModeInfoInternal& mode) const NN_NOEXCEPT;
private:
    mutable bool m_IsFilterUsed;
    bool m_IsValid;
};
