﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nv/nv_MemoryManagement.h>
#include <nv/nv_ServiceName.h>
#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>
#include <nnt/nnt_Argument.h>

namespace
{
    const size_t NvHeapSize = 64 * 1024;

    void* NvAllocate(size_t size, size_t alignment, void* pUserData) NN_NOEXCEPT
    {
        NN_UNUSED(pUserData);
        return std::aligned_alloc(alignment, size);
    }

    void NvFree(void* ptr, void* pUserData) NN_NOEXCEPT
    {
        NN_UNUSED(pUserData);
        std::free(ptr);
    }

    void* NvReallocate(void* ptr, size_t size, void* pUserData) NN_NOEXCEPT
    {
        NN_UNUSED(pUserData);
        return std::realloc(ptr, size);
    }
}

extern "C" void nnMain()
{
    nv::SetGraphicsAllocator(NvAllocate, NvFree, NvReallocate, nullptr);
    nv::SetGraphicsServiceName("nvdrv:s");
    nv::InitializeGraphics(std::malloc(NvHeapSize), NvHeapSize);

    int argc = ::nnt::GetHostArgc();
    char** argv = ::nnt::GetHostArgv();

    NN_LOG("Running nnMain() from testMain_Main.cpp\n");
    ::testing::InitGoogleTest(&argc, argv);

    ::testing::TestEventListeners& listeners =
        ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter =
        listeners.Release(listeners.default_result_printer());
#if defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX)
    listeners.Append(new ::nnt::teamcity::ServiceMessageLogger());
#endif
    listeners.Append(defaultResultPrinter);

    int result = RUN_ALL_TESTS();
    ::nnt::Exit(result);
}
