﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Result.h>
#include <master/detail/visrv_EdidDisplay.h>
#include <nnt/viUtil/testVi_EdidFixture.h>
#include <nn/vi/vi_CmuMode.h>
#include "testDisplay_MockFilter.h"

typedef nnt::vi::util::EdidFixture EdidDisplay;

TEST_F(EdidDisplay, SetAlpha_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetAlpha(1.f));

    display.Close();
}

TEST_F(EdidDisplay, SetPowerState_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetPowerState(nn::vi::PowerState_Off));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetPowerState(nn::vi::PowerState_On));

    display.Close();
}

TEST_F(EdidDisplay, GetPowerState_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::PowerStateType state;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetPowerState(&state));

    display.Close();
}

TEST_F(EdidDisplay, SetLayerStack_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Default));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Lcd));

    display.Close();
}

TEST_F(EdidDisplay, SetCmuLuma_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuLuma(1.f));

    display.Close();
}

TEST_F(EdidDisplay, GetCmuLuma_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float luma;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetCmuLuma(&luma));

    display.Close();
}

TEST_F(EdidDisplay, IsHotplugEventSupported_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    EXPECT_FALSE(display.IsHotplugEventSupported());

    display.Close();
}

TEST_F(EdidDisplay, IsVsyncEventSupported_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    EXPECT_FALSE(display.IsVsyncEventSupported());

    display.Close();
}

TEST_F(EdidDisplay, GetCmuMode_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::CmuModeType mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetCmuMode(&mode));

    display.Close();
}

TEST_F(EdidDisplay, SetCmuMode_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_Disabled));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_Default));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_InvertColor));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_HighContrast));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetCmuMode(nn::vi::CmuMode_Grayscale));

    display.Close();
}

TEST_F(EdidDisplay, GetContrastRatio_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float ratio;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetContrastRatio(&ratio));

    display.Close();
}

TEST_F(EdidDisplay, SetContrastRatio_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetContrastRatio(0.f));

    display.Close();
}

TEST_F(EdidDisplay, GetGamma_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float gamma;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetGamma(&gamma));

    display.Close();
}

TEST_F(EdidDisplay, SetGamma_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetGamma(2.2f));

    display.Close();
}

TEST_F(EdidDisplay, SetViewport_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetViewport(0, 0, 100, 100));

    display.Close();
}

TEST_F(EdidDisplay, GetLayerStack_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::LayerStackType stack;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetLayerStack(&stack));

    display.Close();
}

TEST_F(EdidDisplay, IsModeChangedEventSupported_IcosaCopper)
{
    MockFilter filter;
    nn::visrv::master::detail::EdidDisplay display(&filter);

    EXPECT_FALSE(display.IsModeChangedEventSupported());
}
