﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// Simple CEC API test app

// このテストでは、同一のテストプロセス内で、サーバとクライアントを動作させている。
// 実環境では、一般に、サーバとクライアントは別プロセスとなる。

#include <cstdio>
#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/cec/cec_Api.h>

namespace nn { namespace cec {
namespace {

    const char BusEventNameIgnore[] = "Ignore";
    const char BusEventNameActiveSourceChangedToActive[] = "Active Source --> active";
    const char BusEventNameActiveSourceChangedToInactive[] = "Active Source --> inactive";
    const char BusEventNameGoStandby[] = "Standby";
    const char BusEventNameSuspending[] = "Suspending";
    const char BusEventNameConnectionChange[] = "Connection Change";
    const char BusEventNameOtpFeatureAbort[] = "One Touch Play Feature Abort.";
    const char BusEventNameStandbyFeatureAbort[] = "Standby Feature Abort.";
    const char BusEventNameSetOnScreenStringFeatureAbort[] = "Set On Screen String Feature Abort";
    const char BusEventNameStarted[] = "Started";

    const char* BusEvent2String(BusEventType busEvent)
    {
        const char* rval;

        switch(busEvent)
        {
            case BusEventType_Ignore:
                rval = BusEventNameIgnore;
                break;
            case BusEventType_ActiveSourceChangedToActive:
                rval = BusEventNameActiveSourceChangedToActive;
                break;
            case BusEventType_ActiveSourceChangedToInactive:
                rval = BusEventNameActiveSourceChangedToInactive;
                break;
            case BusEventType_GoStandby:
                rval = BusEventNameGoStandby;
                break;
            case BusEventType_Suspending:
                rval = BusEventNameSuspending;
                break;
            case BusEventType_ConnectionChange:
                rval = BusEventNameConnectionChange;
                break;
            case BusEventType_FeatureAbortOneTouchPlay:
                rval = BusEventNameOtpFeatureAbort;
                break;
            case BusEventType_FeatureAbortStandby:
                rval = BusEventNameStandbyFeatureAbort;
                break;
            case BusEventType_FeatureAbortSetOnScreenString:
                rval = BusEventNameSetOnScreenStringFeatureAbort;
                break;
            case BusEventType_Started:
                rval = BusEventNameStarted;
                break;
            default:
                rval = nullptr;
                break;
        }
        return rval;
    }

    const char ConnectionStateNameNotConnected[] = "Not Connected";
    const char ConnectionStateNameOnlyCradleConnected[] = "Cradle Connected";
    const char ConnectionStateNameCradleAndTvConnected[] = "Cradle And TV Connected";

    const char* ConnectionState2String(ConnectionState connectionState)
    {
        const char* rval;

        switch(connectionState)
        {
            case ConnectionState_NotConnected:
                rval = ConnectionStateNameNotConnected;
                break;
            case ConnectionState_OnlyCradleConnected:
                rval = ConnectionStateNameOnlyCradleConnected;
                break;
            case ConnectionState_CradleAndTvConnected:
                rval = ConnectionStateNameCradleAndTvConnected;
                break;
            default:
                rval = nullptr;
                break;
        }
        return rval;
    }

extern "C" void nnMain()
{
    nn::os::SystemEventType systemEvent;
    nn::Result              result;
    BusEventType            busEvent;
    ConnectionState         connectionState;

    NN_SDK_LOG("%s: CEC monitor Enter\n", __func__);

    Initialize(&systemEvent);

    do
    {
        nn::os::WaitSystemEvent(&systemEvent);
        result = GetBusEventType(&busEvent);
        if(result.GetDescription() == 0)
        {
            const char* name;

            name = BusEvent2String(busEvent);
            if(busEvent == BusEventType_ConnectionChange)
            {
                result = GetConnectionState(&connectionState);
                if(result.GetDescription() == 0)
                {
                    const char* connectionName;

                    connectionName = ConnectionState2String(connectionState);
                    NN_SDK_LOG("[CEC]\t%s %s\n", name, connectionName);
                }
            }
            else
            {
                NN_SDK_LOG("[CEC]\t%s\n", name);
            }
        }
    } while(result.GetDescription() == 0);

    Finalize(&systemEvent);
    NN_SDK_LOG("%s: CEC Monitor Leave\n", __func__);
}

}
}}
