<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Updates TV-specific parameters

    .DESCRIPTION
        As different TVs have different requirements and the TVs can be cycled through the display lab, this script handles any TV that is connected
#>

    
function Check-For-Compatibility([string]$edid, [Boolean]$powerOffTV)
{
    Write-Host "Checking for TV compatibility with test..."
    if ($powerOffTV)
    {
        if ($edid -eq "SHP-3263" -or $edid -eq "VIZ-1007" -or $edid -eq "VIZ-1011" -or $edid -eq "BBY-19" -or $edid -eq "TCL-0")
        {
            Write-Host "TV incompatible due to inability to power off"
            Write-Host "Skipping"
            exit 0
        }
    }
    
}

function Update-Tv-Parameters([string]$edid)
{
    #################################################
    # Overwrite the amplitude and sleep delay for known TVs
    #
    # After using Apply-Amplitude-Multiplier on the amplitude, the value must be between 0 and 32k
    # The values here should result in it being detected at a level of around 7000 by the audio server
    #
    
    if ($edid -eq "XXX-0")
    {
        # HiSense 32H3B1
        $script:Amplitude = 455
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "SNY-d703")
    {
        # Sony KDL-32R300C
        $script:Amplitude = 230
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "SNY-ef03")
    {
        # Sony KDL-32W600D
        $script:Amplitude = 150
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "SNY-f301")
    {
        # Sony KDL-40HX800
        $script:Amplitude = 1000
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "SHP-3263")
    {
        # Sharp LC-32LB480U
        $script:Amplitude = 850
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "SHP-4176")
    {
        # Sharp LC-22LS5510UT
        $script:Amplitude = 850
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "PHL-0")
    {
        # Phillips 32PFL4909/F7
        # Phillips 32PFL4505/F7
        # Phillips 46PFL3706/F7
        $script:Amplitude = 1000
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "BBY-3536")
    {
        # Insignia NS-24D420NA16
        $script:Amplitude = 230
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "BBY-19")
    {
        # Insignia NS-24D420NA16-A
        $script:Amplitude = 800
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "VIZ-1007")
    {
        # Vizio D32h-C0
        $script:Amplitude = 260
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "VIZ-1011")
    {
        # Vizio D40u-D1
        $script:Amplitude = 260
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "FNI-0")
    {
        # Magnavox 32ME306V/F7
        $script:Amplitude = 500
        $script:SleepDelay = 10
    }
    elseif ($edid -eq "TCL-0")
    {
        # TCL 32S3800
        $script:Amplitude = 5500
        $script:SleepDelay = 10
    }
    else
    {
        Write-Host "WARNING: Unknown TV being tested.  Results may be invalid."
        return
    }
    
    Write-Host "Changed Amplitude to ${script:Amplitude}"
    Write-Host "Changed Sleep Delay to ${script:SleepDelay}"
}

