﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/edid.h>
#include <nn/settings/system/settings_Tv.h>

#include <nn/nn_Log.h>

extern "C" void nnMain()
{
    nn::settings::system::Edid s_pEdidRaw;
    nn::settings::system::GetEdid(&s_pEdidRaw);

    nn::edid::Edid edid;
    if (nn::edid::OpenEdid(&edid, &s_pEdidRaw, sizeof(s_pEdidRaw)) != nn::edid::Error_None)
    {
        NN_LOG("<edid>invalid</edid>");
        return;
    }

    nn::edid::DisplayInfo display;
    nn::edid::GetDisplayInfo(&display, &edid);

    NN_LOG("<edid>%s-%x</edid>\n", display.manufacturerCode, display.productCode);

    return;
}
