﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "FrequencyList.h"

FrequencyList::FrequencyList()
{
    InitializeCriticalSection(&critical);
}

// Adds a frequency to the list
// Does nothing if the list already has the frequency
void FrequencyList::Add(int frequency)
{
    if (Contains(frequency))
    {
        return;
    }

    EnterCriticalSection(&critical);

    list.push_back(frequency);

    LeaveCriticalSection(&critical);
}

// Removes a frequency from the list
void FrequencyList::Remove(int frequency)
{
    EnterCriticalSection(&critical);

    list.remove(frequency);

    LeaveCriticalSection(&critical);
}

// Clear the frequency list
void FrequencyList::Clear()
{
    EnterCriticalSection(&critical);

    list.clear();

    LeaveCriticalSection(&critical);
}

// Returns whether a given frequency is in the list
bool FrequencyList::Contains(int frequency)
{
    bool found = false;

    EnterCriticalSection(&critical);

    for (std::list<int>::iterator iter = list.begin(); iter != list.end(); ++iter)
    {
        if (*iter == frequency)
        {
            found = true;
            break;
        }
    }

    LeaveCriticalSection(&critical);

    return found;
}

// Turns the frequency list into an array
// Must be freed by called
int FrequencyList::GenerateArray(int** out)
{
    EnterCriticalSection(&critical);

    if (list.empty())
    {
        LeaveCriticalSection(&critical);
        return 0;
    }

    int size = 0;
    *out = new int[list.size()];

    for (std::list<int>::iterator iter = list.begin(); iter != list.end(); ++iter)
    {
        (*out)[size] = *iter;

        ++size;
    }

    LeaveCriticalSection(&critical);

    return size;
}
