﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt/nntest.h>
#include <nn/diag/detail/diag_DetailTranslation.h>

#include "testDiag_Translation.dictionary.h"
#include "testDiag_Translation.dictionary.dummy.h"

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)

// 辞書データを検索して結果を検証する、正常系テスト
TEST(TranslationTest, Hit)
{
    // 辞書を検索
    const char* result = NN_SDK_TEXT_TESTDIAG("こんにちは\n");
    ASSERT_STREQ("Hello\n", result);
}

#elif defined(NN_SDK_BUILD_RELEASE)

// リリースビルドでは、辞書検索が行われない
TEST(TranslationTest, Hit)
{
    // 辞書を検索
    const char* result = NN_SDK_TEXT_TESTDIAG("こんにちは\n");

    // "こんにちは\n" の UTF-8 データ
    // Visual Studio でも UTF-8 にするため、文字列リテラルではなく配列で記述
    const uint8_t expected[] = {
        0xe3, 0x81, 0x93,
        0xe3, 0x82, 0x93,
        0xe3, 0x81, 0xab,
        0xe3, 0x81, 0xa1,
        0xe3, 0x81, 0xaf,
        0x0a,
        0x00
    };

    ASSERT_STREQ(reinterpret_cast<const char*>(expected), result);
}

#else
#error "ビルドタイプマクロが定義されていません。"
#endif

// 不正な辞書データの場合は、key として与えた文字列が UTF-8 で返ってくる
TEST(TranslationTest, InvalidDictionary)
{
    // 辞書を検索
    const char* result = NN_SDK_TEXT_TESTDIAGDUMMY("こんにちは\n");

    // "こんにちは\n" の UTF-8 データ
    // Visual Studio でも UTF-8 にするため、文字列リテラルではなく配列で記述
    const uint8_t expected[] = {
        0xe3, 0x81, 0x93,
        0xe3, 0x82, 0x93,
        0xe3, 0x81, 0xab,
        0xe3, 0x81, 0xa1,
        0xe3, 0x81, 0xaf,
        0x0a,
        0x00
    };

    ASSERT_STREQ(reinterpret_cast<const char*>(expected), result);
}

// 検索がヒットしない場合は、key として与えた文字列が UTF-8 で返ってくる
TEST(TranslationTest, Miss)
{
    // 辞書を検索
    const char* result = NN_SDK_TEXT_TESTDIAG("はちにんこ\n");

    // "はちにんこ\n" の UTF-8 データ
    // Visual Studio でも UTF-8 にするため、文字列リテラルではなく配列で記述
    const uint8_t expected[] = {
        0xe3, 0x81, 0xaf,
        0xe3, 0x81, 0xa1,
        0xe3, 0x81, 0xab,
        0xe3, 0x82, 0x93,
        0xe3, 0x81, 0x93,
        0x0a,
        0x00
    };

    ASSERT_STREQ(reinterpret_cast<const char*>(expected), result);
}
