﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/diag.h>
#include <nn/diag/detail/diag_Log.h>

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)

namespace
{
    nn::diag::LogMetaData g_LogMetaData;
}

// モジュール名、重大性、冗長性が正しくセットされるか確認するテスト
TEST(LogTest, LogMetaData)
{
    // テスト用オブザーバーの登録
    nn::diag::LogObserverHolder logObserverHolder;
    nn::diag::InitializeLogObserverHolder(
        &logObserverHolder,
        []( const nn::diag::LogMetaData& metaData,
            const nn::diag::LogBody& /*body*/,
            void* /*argument*/)
        {
            g_LogMetaData = metaData;
        },
        NULL);
    nn::diag::RegisterLogObserver(&logObserverHolder);

    // -------------------------------------------------------------------------
    // NN_DETAIL_DIAG_TRACE*() のテスト
    // -------------------------------------------------------------------------
    NN_DETAIL_DIAG_TRACE("test by NN_DETAIL_DIAG_TRACE\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(0, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Trace, g_LogMetaData.severity);

    NN_DETAIL_DIAG_TRACE_V1("test by NN_DETAIL_DIAG_TRACE_V1\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(1, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Trace, g_LogMetaData.severity);

    NN_DETAIL_DIAG_TRACE_V2("test by NN_DETAIL_DIAG_TRACE_V2\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(2, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Trace, g_LogMetaData.severity);

    NN_DETAIL_DIAG_TRACE_V3("test by NN_DETAIL_DIAG_TRACE_V3\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(3, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Trace, g_LogMetaData.severity);

    // -------------------------------------------------------------------------
    // NN_DETAIL_DIAG_INFO*() のテスト
    // -------------------------------------------------------------------------
    NN_DETAIL_DIAG_INFO("test by NN_DETAIL_DIAG_INFO\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(0, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Info, g_LogMetaData.severity);

    NN_DETAIL_DIAG_INFO_V1("test by NN_DETAIL_DIAG_INFO_V1\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(1, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Info, g_LogMetaData.severity);

    NN_DETAIL_DIAG_INFO_V2("test by NN_DETAIL_DIAG_INFO_V2\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(2, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Info, g_LogMetaData.severity);

    NN_DETAIL_DIAG_INFO_V3("test by NN_DETAIL_DIAG_INFO_V3\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(3, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Info, g_LogMetaData.severity);

    // -------------------------------------------------------------------------
    // NN_DETAIL_DIAG_WARN*() のテスト
    // -------------------------------------------------------------------------
    NN_DETAIL_DIAG_WARN("test by NN_DETAIL_DIAG_WARN\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(0, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Warn, g_LogMetaData.severity);

    NN_DETAIL_DIAG_WARN_V1("test by NN_DETAIL_DIAG_WARN_V1\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(1, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Warn, g_LogMetaData.severity);

    NN_DETAIL_DIAG_WARN_V2("test by NN_DETAIL_DIAG_WARN_V2\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(2, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Warn, g_LogMetaData.severity);

    NN_DETAIL_DIAG_WARN_V3("test by NN_DETAIL_DIAG_WARN_V3\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(3, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Warn, g_LogMetaData.severity);

    // -------------------------------------------------------------------------
    // NN_DETAIL_DIAG_ERROR*() のテスト
    // -------------------------------------------------------------------------
    NN_DETAIL_DIAG_ERROR("test by NN_DETAIL_DIAG_ERROR\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(0, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Error, g_LogMetaData.severity);

    NN_DETAIL_DIAG_ERROR_V1("test by NN_DETAIL_DIAG_ERROR_V1\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(1, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Error, g_LogMetaData.severity);

    NN_DETAIL_DIAG_ERROR_V2("test by NN_DETAIL_DIAG_ERROR_V2\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(2, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Error, g_LogMetaData.severity);

    NN_DETAIL_DIAG_ERROR_V3("test by NN_DETAIL_DIAG_ERROR_V3\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(3, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Error, g_LogMetaData.severity);

    // -------------------------------------------------------------------------
    // NN_DETAIL_DIAG_FATAL*() のテスト
    // -------------------------------------------------------------------------
    NN_DETAIL_DIAG_FATAL("test by NN_DETAIL_DIAG_FATAL\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(0, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Fatal, g_LogMetaData.severity);

    NN_DETAIL_DIAG_FATAL_V1("test by NN_DETAIL_DIAG_FATAL_V1\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(1, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Fatal, g_LogMetaData.severity);

    NN_DETAIL_DIAG_FATAL_V2("test by NN_DETAIL_DIAG_FATAL_V2\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(2, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Fatal, g_LogMetaData.severity);

    NN_DETAIL_DIAG_FATAL_V3("test by NN_DETAIL_DIAG_FATAL_V3\n");
    EXPECT_STREQ("$diag", g_LogMetaData.moduleName);
    EXPECT_EQ(3, g_LogMetaData.verbosity);
    EXPECT_EQ(nn::diag::LogSeverity_Fatal, g_LogMetaData.severity);

    // テスト用オブザーバーの登録解除
    nn::diag::UnregisterLogObserver(&logObserverHolder);
} //NOLINT(impl/function_size)

#endif // #if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
