﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt/nntest.h>
#include <nn/nn_Assert.h>
#include <nn/nn_SdkAssert.h>
#include <nn/diag/diag_AssertionFailureHandler.h>
#include "testDiag_AssertTestUtil.h"

// カスタムのハンドラで、Assertion 失敗時に処理を継続
TEST(AssertTest, ContinuingCustomHandler)
{
    ScopedSetAssertionFailureHandler setContinuingHandler(ContinuingAssertionFailureHandler);

    ClearCustomHandlerCalled();
    NN_ASSERT(false);
    EXPECT_TRUE(IsCustomHandlerCalled());
}

#if defined(NN_BUILD_CONFIG_OS_WIN)

// 独自のハンドラで、Assertion 失敗時に処理を停止
TEST(AssertDeathTest, AbortingCustomHandler)
{
    nn::diag::SetAssertionFailureHandler(AbortingAssertionFailureHandler);
    EXPECT_DEATH(
        NN_ASSERT(false, ""),
        "");
}

#endif // defined(NN_BUILD_CONFIG_OS_WIN)

// AssertionType の確認
TEST(AssertTest, AssertionType)
{
    ScopedSetAssertionFailureHandler setContinuingHandler(ContinuingAssertionFailureHandler);

    ClearCustomHandlerCalled();
    NN_ASSERT(false);
    EXPECT_TRUE(IsCustomHandlerCalled());
    EXPECT_EQ(nn::diag::AssertionType_UserAssert, GetLastAssertionType());

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)

    ClearCustomHandlerCalled();
    NN_SDK_ASSERT(false);
    EXPECT_TRUE(IsCustomHandlerCalled());
    EXPECT_EQ(nn::diag::AssertionType_SdkAssert, GetLastAssertionType());

    ClearCustomHandlerCalled();
    NN_SDK_REQUIRES(false);
    EXPECT_TRUE(IsCustomHandlerCalled());
    EXPECT_EQ(nn::diag::AssertionType_SdkRequires, GetLastAssertionType());

#endif // defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
}
