﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Common.h>

#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nnt/fsUtil/testFs_util.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>

//#define ACTIVATE_PROFILELOG
#ifdef ACTIVATE_PROFILELOG
    #include "ProfileLog.h"
#endif

int commonMain(int argc, char** argv)
{
    ::testing::InitGoogleTest(&argc,argv);

    int result = RUN_ALL_TESTS();

    return result;
}

extern "C" void nnMain()
{
    int argc = nnt::GetHostArgc();
    char** argv = nnt::GetHostArgv();

    NN_LOG("Running nnMain() from testCrypto_Cavs.cpp\n");
    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nn::fs::MountHostRoot();

    static const size_t MountRomCacheBufferSize = 4 * 1024;
    static char s_MountRomCacheBuffer[MountRomCacheBufferSize];
    size_t mountRomCacheUseSize = 0;
    nn::fs::QueryMountRomCacheSize(&mountRomCacheUseSize);
    ASSERT_LE(mountRomCacheUseSize, MountRomCacheBufferSize);

    nn::fs::MountRom("rom", s_MountRomCacheBuffer, MountRomCacheBufferSize);
#ifdef ACTIVATE_PROFILELOG
    ProfileLog::InitializeGlobalLog("profilelog.csv");
#endif
    commonMain(argc,argv);
#ifdef ACTIVATE_PROFILELOG
    ProfileLog::FinalizeGlobalLog();
#endif
    nn::fs::UnmountHostRoot();
    nn::fs::Unmount("rom");
}
