﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class StackCheck
{
public:
    static const unsigned int Size = 10 * 1024;
    static const uint32_t Marker = 0x57AC3DA7;
    static const int Count = Size / sizeof(Marker);

    int m_PreventCodeRemoval;
    int m_Max;
    uint32_t* m_Cover;
    int m_Usage;

    explicit StackCheck( int maxStack = -1 )
    {
        m_Max = maxStack;
        m_PreventCodeRemoval = Init();
    }

    int Init()
    {
        uint32_t cover[Count];
        m_Cover = &cover[0];

        int sum = 0;
        for ( int i = 0; i < Count; ++i )
        {
            sum += m_Cover[i];
            m_Cover[i] = Marker;
        }
        return sum;
    }

    void Scan()
    {
        int i0 = 4 * 20;
        int i = i0;
        for (; i < Count; ++i )
        {
            if ( m_Cover[i] != Marker )
            {
                break;
            }
        }
        m_Usage = i > i0 ? (Count - i) * sizeof(Marker) : 0;
    }

    void Check()
    {
        if ( m_Usage )
        {
            LocalLog( CSV_SEP "%s%d", (m_PreventCodeRemoval & 1) != 0 ? "" : " ", m_Usage );
        }
        else
        {
            LocalLog( CSV_SEP "unknown");
        }
        if ( m_Max >= 0 )
        {
            ASSERT_NE( m_Usage, 0 );
            //ASSERT_LE( measuredUsage, m_Max );
        }
    }
};
