﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef LocalLog
    #ifdef ANDROID
        #define LocalLog(...) fprintf(stderr,__VA_ARGS__)
    #else
        #include <nn/nn_Log.h>
        #define LocalLog NN_LOG
    #endif
#endif

#define CSV_SEP "\t"

//#include "HeapCheck.h"
#include "StackCheck.h"
#include "TimeCheck.h"

class ProfileCheck
{
public:
    //HeapCheck m_HeapCheck;
    StackCheck m_StackCheck;
    TimeCheck m_TimeCheck;
    const char* m_Name;
    int m_Repeat;

    ProfileCheck( const char* name, int timeMax = -1, int stackMax = -1, int heapMax = -1,
                  int heapMaxCount = -1, int repeat = 1 )
        : m_StackCheck( stackMax ),
          m_TimeCheck( timeMax )
          /*m_HeapCheck( heapMax, heapMaxCount ),*/
    {
        //NN_UNUSED(stackMax);
        NN_UNUSED(heapMax);
        NN_UNUSED(heapMaxCount);
        m_Name = name;
        m_Repeat = repeat;
    }

    ~ProfileCheck()
    {
        m_TimeCheck.End();
        m_StackCheck.Scan();
        LocalLog("\n");
        static bool headersPrinted;
        if ( !headersPrinted )
        {
            LocalLog(
                "Name" CSV_SEP "Duration" CSV_SEP "StackUsage" CSV_SEP "HeapUsage" CSV_SEP "HeapAllocCount\n" );
            headersPrinted = true;
        }
        LocalLog( "%s", m_Name );
        m_TimeCheck.Check( m_Repeat );
        m_StackCheck.Check();
        //m_HeapCheck.Check( m_Repeat );
        LocalLog( "\n" );
    }

#if defined(WIN32) /* && defined(NN_SDK_BUILD_RELEASE) */
    #define PROFILE_CHECK_Win   ProfileCheck win ## __LINE__
#else
    #define PROFILE_CHECK_Win(...)
#endif

#if defined(ANDROID) && defined(NN_SDK_BUILD_RELEASE) && defined(APP_CMDLINE)
    #define PROFILE_CHECK_AndroidTX1   ProfileCheck android ## __LINE__
#else
    #define PROFILE_CHECK_AndroidTX1(...)
#endif

#if defined(NN_BUILD_CONFIG_OS_HORIZON) /* && defined(NN_SDK_BUILD_RELEASE) */
    #define PROFILE_CHECK_OsHorizon   ProfileCheck oshorizon ## __LINE__
#else
    #define PROFILE_CHECK_OsHorizon(...)
#endif

#if defined(NN_BUILD_CONFIG_OS_HORIZON) && defined(NN_BUILD_CONFIG_CPU_ARM)
    #define PROFILE_CHECK_OsHorizon_AArch32   ProfileCheck oshorizonAArch32 ## __LINE__
#else
    #define PROFILE_CHECK_OsHorizon_AArch32(...)
#endif

#if defined(NN_BUILD_CONFIG_OS_HORIZON) && defined(NN_BUILD_CONFIG_CPU_ARM64)
    #define PROFILE_CHECK_OsHorizon_AArch64   ProfileCheck oshorizonAArch64 ## __LINE__
#else
    #define PROFILE_CHECK_OsHorizon_AArch64(...)
#endif
};
