﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/crypto/crypto_Aes128GcmDecryptor.h>
#include <nn/crypto/crypto_Aes128GcmEncryptor.h>
#include <nnt/nntest.h>

static const unsigned char gKey[] =
{
    0xc9,0x39,0xcc,0x13,0x39,0x7c,0x1d,0x37,0xde,0x6a,0xe0,0xe1,0xcb,0x7c,0x42,0x3c
};

static const unsigned char gIV[] =
{
    0xb3,0xd8,0xcc,0x01,0x7c,0xbb,0x89,0xb3,0x9e,0x0f,0x67,0xe2,
};

static const unsigned char gAad[] =
{
    0x24,0x82,0x56,0x02,0xbd,0x12,0xa9,0x84,0xe0,0x09,0x2d,0x3e,0x44,0x8e,0xda,0x5f,
};

static const unsigned char gPlainText[] =
{
    0xc3,0xb3,0xc4,0x1f,0x11,0x3a,0x31,0xb7,0x3d,0x9a,0x5c,0xd4,0x32,0x10,0x30,0x69,
};

static const unsigned char gCipherText[] =
{
    0x93,0xfe,0x7d,0x9e,0x9b,0xfd,0x10,0x34,0x8a,0x56,0x06,0xe5,0xca,0xfa,0x73,0x54,
};

static const unsigned char gTag[] =
{
    0x00,0x32,0xa1,0xdc,0x85,0xf1,0xc9,0x78,0x69,0x25,0xa2,0xe7,0x1d,0x82,0x72,0xdd,
};

TEST(Aes128Gcm, Decrypt1)
{
    char outPlain[sizeof(gCipherText)];
    char outTag[nn::crypto::Aes128GcmDecryptor::MacSize];

    std::memset(outPlain, 0xBD, sizeof(outPlain));
    std::memset(outTag, 0xBD, sizeof(outTag));

    nn::crypto::DecryptAes128Gcm( outPlain, sizeof(outPlain),
                                  outTag, sizeof(outTag),
                                  gKey, sizeof(gKey), gIV, sizeof(gIV),
                                  gCipherText, sizeof(gCipherText),
                                  gAad, sizeof(gAad) );

    /// Check authenticity
    EXPECT_EQ( 0, std::memcmp( outTag, gTag, sizeof(gTag) ) );
    /// Check decryption output
    EXPECT_EQ( 0, std::memcmp( outPlain, gPlainText, sizeof(gPlainText) ) );
}

TEST(Aes128Gcm, Encrypt1)
{
    char outCipher[sizeof(gPlainText)];
    char outTag[sizeof(gTag)];

    std::memset(outCipher, 0xBD, sizeof(outCipher));
    std::memset(outTag, 0xBD, sizeof(outTag));

    nn::crypto::EncryptAes128Gcm( outCipher, sizeof(outCipher),
                                  outTag, sizeof(outTag),
                                  gKey, sizeof(gKey), gIV, sizeof(gIV),
                                  gPlainText, sizeof(gPlainText),
                                  gAad, sizeof(gAad) );

    /// Check MAC output
    EXPECT_EQ( 0, std::memcmp(outTag, gTag, sizeof(gTag) ) );

    /// Check encryption output
    EXPECT_EQ( 0, std::memcmp( outCipher, gCipherText, sizeof(gCipherText) ) );
}
