﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <iomanip>
#include <nn/util/util_FormatString.h>
#include "ConsumableServiceItem_LibraryApi.h"

namespace nn { namespace ConsumableServiceItem {

Result GetRights(Right* pOutRights, int* pOutRightsCount, const int maxRightsCount, const char* applicationId, const char* nsaId) NN_NOEXCEPT
{
    //! curl GET /v1/applications/{applicationId}/accounts/{nsaId}/rights

    *pOutRightsCount = std::min(maxRightsCount, 20);

    for (int i = 0; i < *pOutRightsCount; i++)
    {
        util::SNPrintf(pOutRights[i].rightId, IdLength, "01%014llx", i);
        util::SNPrintf(pOutRights[i].nsaId, IdLength, "%s", nsaId);
        util::SNPrintf(pOutRights[i].itemId, IdLength, "%s", "0100000000000001");
        pOutRights[i].purchasedDataTime = 0;
        util::SNPrintf(pOutRights[i].country, CountryLength, "%s", "JP");
    }

    //! TORIAEZU : Right Id が 0 - 19 の権利を取得する
    NN_RESULT_SUCCESS;
}

Result ConsumeRight(const char* rightId, const char* applicationId, const char* nsaId) NN_NOEXCEPT
{
    //! curl PUT /v1/applications/{applicationId}/accounts/{nsaId}/rights

    //! TORIAEZU: Sugar の権利が問題なく消費完了したとみなす
    NN_RESULT_SUCCESS;
}

}
}
