﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/graphics/testGraphics_GetHostExecutableFilepath.h>

#include <cstring>
#include <nn/nn_Assert.h>

#pragma warning(push)
#pragma warning(disable: 4668)
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>
#pragma warning(pop)

namespace nnt{ namespace graphics{

    const char* GetHostExecutableFilepath() NN_NOEXCEPT
    {
        static const int MaxPathLength = 512;
        static char s_Path[MaxPathLength] = {};

        if( s_Path[0] == '\0' )
        {
            // 実行ファイルのパスを取得
            const int filepathLength = GetModuleFileNameA(NULL, s_Path, MaxPathLength);
            NN_ASSERT( filepathLength < MaxPathLength );
            NN_ASSERT( GetLastError() == ERROR_SUCCESS );
        }

        return s_Path;
    }

}}
