﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <zlib.h>
#include <nn/fs.h>
#include <nnt/gfx/testGfx_FileSystem.h>
#include <nnt/gfx/testGfx_PngIO.h>

namespace nnt {
namespace gfx {


//------------------------------------------------------------------------------
//  32bitデータをストリームに出力
//------------------------------------------------------------------------------
void NntGfxPngIO::Output32( std::ostream* pStream, const void* pData, uint32_t* pCrc )
{
    uint32_t data = *static_cast<const uint32_t*>( pData );

    pStream->write( reinterpret_cast<const char*>( &data ), 4 );

    if (pCrc != NULL)
    {
        *pCrc = crc32( *pCrc, reinterpret_cast<const Bytef*>( &data ), 4 );
    }
}

//------------------------------------------------------------------------------
//  圧縮率を上げるため画像にフィルターをかける
//------------------------------------------------------------------------------
void NntGfxPngIO::CompressFilter( const uint8_t* pInput, int width, int height, uint8_t pixelBytes, uint8_t* pOutput )
{
    for ( uint32_t y = 0; y < height; ++y )
    {
        const uint8_t* pInputLine = &pInput[y * ( width * 3 )];
        uint8_t* pOutputLine = &pOutput[y * ( 1 + width * 3 )];

        pOutputLine[0] = 0;

        for ( uint32_t x = 0; x < width; ++x )
        {
            pOutputLine[1 + ( x * 3 ) + 0] = pInputLine[( x * 3 ) + 0];
            pOutputLine[1 + ( x * 3 ) + 1] = pInputLine[( x * 3 ) + 1];
            pOutputLine[1 + ( x * 3 ) + 2] = pInputLine[( x * 3 ) + 2];
        }
    }
}

//------------------------------------------------------------------------------
// 32bitデータをストリームから入力
//------------------------------------------------------------------------------
uint32_t NntGfxPngIO::Input32( uint8_t** pStream )
{
    uint32_t data;
    memcpy( &data, *pStream, 4 );

    *pStream = *pStream + 4;

    return data;
}

//------------------------------------------------------------------------------
// フィルタを適用したピクセルデータを復元
//------------------------------------------------------------------------------
void NntGfxPngIO::DecompressFilter( const uint8_t* pInput, int width, int height, uint8_t pixelBytes, uint8_t* pOutput )
{
    for ( uint32_t y = 0; y < height; ++y )
    {
        const uint8_t* pInputLine = &pInput[y * ( 1 + width * 3 )];
        uint8_t* pOutputLine = &pOutput[y * ( width * 3 )];

        for ( uint32_t x = 0; x < width; ++x )
        {
            pOutputLine[( x * 3 ) + 0] = pInputLine[1 + ( x * 3 ) + 0];
            pOutputLine[( x * 3 ) + 1] = pInputLine[1 + ( x * 3 ) + 1];
            pOutputLine[( x * 3 ) + 2] = pInputLine[1 + ( x * 3 ) + 2];
        }
    }
}

}
}
