﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/fs.h>

// VS2015 で _IO_FILE の構成が全く違うものになっていたいたので、早々に変更。
// FILE の定義を強引に置き換える。
typedef struct tag_IO_FILE_LOCAL
{
    int64_t fileSize;
    int64_t currentPosition;
    nn::fs::FileHandle* handle;
    bool isNeededFlush;
} _IO_FILE_LOCAL;

// opus_demo.c と opus_compare.c から呼ばれる。
extern "C" {

FILE* FileOpen(const char *filepath, const char *mode)
{
    _IO_FILE_LOCAL* pFile = new _IO_FILE_LOCAL[1];
    nn::fs::FileHandle* pHandle = new nn::fs::FileHandle[1];
    // 雑な実装
    if (mode[0] == 'r')
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::OpenFile(pHandle, filepath, nn::fs::OpenMode_Read));
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::GetFileSize(&pFile->fileSize, *pHandle));
        pFile->handle = pHandle;
        pFile->currentPosition = 0;
        pFile->isNeededFlush = false;
    }
    else if (mode[0] == 'w')
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::CreateFile(filepath, 0));
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::OpenFile(pHandle, filepath, nn::fs::OpenMode_Write | nn::fs::OpenMode_AllowAppend));
        pFile->handle = pHandle;
        pFile->currentPosition = 0;
        pFile->isNeededFlush = true;
    }
    else if (mode[0] == 'a')
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::CreateFile(filepath, 0));
        NNT_EXPECT_RESULT_SUCCESS(nn::fs::OpenFile(pHandle, filepath, nn::fs::OpenMode_Write | nn::fs::OpenMode_AllowAppend));
        pFile->handle = pHandle;
        pFile->currentPosition = 0;
        pFile->isNeededFlush = true;
    }
    return reinterpret_cast<FILE*>(pFile);
}

int FileClose(FILE *pFile)
{
    _IO_FILE_LOCAL* stream = reinterpret_cast<_IO_FILE_LOCAL*>(pFile);
    nn::fs::FileHandle* pHandle = stream->handle;
    if (stream->isNeededFlush)
    {
        nn::fs::FlushFile(*pHandle);
    };
    nn::fs::CloseFile(*pHandle);
    delete[] stream->handle;
    delete[] stream;
    return 0;
    //return fclose(stream);
}

long FileTell(FILE *pFile)
{
    const _IO_FILE_LOCAL* stream = reinterpret_cast<_IO_FILE_LOCAL*>(pFile);
    return static_cast<long>(stream->currentPosition);
    //return ftell(stream);
}

int FileSeek(FILE *pFile, long offset, int base)
{
    _IO_FILE_LOCAL* stream = reinterpret_cast<_IO_FILE_LOCAL*>(pFile);
    const int64_t fileSize = stream->fileSize;
    int64_t currentPosition;
    switch(base)
    {
    case SEEK_SET:
        currentPosition = 0;
        break;
    case SEEK_CUR:
        currentPosition = stream->currentPosition;
        break;
    case SEEK_END:
        currentPosition = fileSize;
        break;
    default:
        return -1;
    }
    currentPosition += offset;
    if (currentPosition < 0 || fileSize < currentPosition)
    {
        return -1;
    }
    stream->currentPosition = currentPosition;
    return 0;
    //return fseek(stream, offset, base);
}

size_t FileRead(void * __restrict pBuffer, size_t blockSize, size_t blockCount, FILE * __restrict pFile)
{
    size_t outSize;
    size_t size = blockSize * blockCount;
    _IO_FILE_LOCAL* stream = reinterpret_cast<_IO_FILE_LOCAL*>(pFile);
    int64_t offset = stream->currentPosition;
    const int64_t fileSize = stream->fileSize;
    if (fileSize < static_cast<int64_t>(offset + size))
    {
        size = static_cast<size_t>(fileSize - offset);
    }
    NNT_EXPECT_RESULT_SUCCESS(nn::fs::ReadFile(&outSize, *stream->handle, offset, pBuffer, size));
    offset += outSize;
    stream->currentPosition = offset;
    return static_cast<size_t>(outSize / blockSize);
    //return fread(pBuffer, blockSize, blockCount, stream);
}

size_t FileWrite(const void * __restrict pBuffer, size_t blockSize, size_t blockCount, FILE * __restrict pFile)
{
    _IO_FILE_LOCAL* stream = reinterpret_cast<_IO_FILE_LOCAL*>(pFile);
    int64_t offset = stream->currentPosition;
    NNT_EXPECT_RESULT_SUCCESS(nn::fs::WriteFile(*stream->handle, offset, pBuffer, blockSize * blockCount, nn::fs::WriteOption()));
    offset += blockSize * blockCount;
    stream->currentPosition = offset;
    return blockCount;
    //return fwrite(pBuffer, blockSize, blockCount, stream);
}

int FileEof(FILE *pFile)
{
    _IO_FILE_LOCAL* stream = reinterpret_cast<_IO_FILE_LOCAL*>(pFile);
    const int64_t currentPosition = stream->currentPosition;
    return currentPosition == stream->fileSize;
    //return feof(stream);
}

}; // extern "C" {
