﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/os.h>
#include <nn/init/init_Malloc.h>
#include <nn/usb/usb_Host.h>
#include <nn/cdmsc.h>

#include <nnt.h>

namespace nnt {
namespace usb {
namespace cdmsc {


extern "C" void nninitStartup()
{
    NN_LOG("nninitStartup loaded %p\n", nninitStartup);
    // メモリヒープの全体サイズを設定する
    const size_t MemoryHeapSize = 128 * 1024 * 1024;
    NN_ABORT_UNLESS(nn::os::SetMemoryHeapSize( MemoryHeapSize ).IsSuccess());

    // メモリヒープから malloc で使用するメモリ領域を確保
    uintptr_t address = 0;

    NN_ABORT_UNLESS(nn::os::AllocateMemoryBlock( &address, MemoryHeapSize ).IsSuccess());

    // malloc 用のメモリ領域を設定する
    nn::init::InitializeAllocator( reinterpret_cast<void*>(address), MemoryHeapSize );

}

}
}
}
