﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#define NNT_CAPSRV_MAKERNOTE_CONCAT_I(x) x
#define NNT_CAPSRV_MAKERNOTE_CONCAT(a, b) NNT_CAPSRV_MAKERNOTE_CONCAT_I(a ## b)

#define NNT_CAPSRV_MAKERNOTE_STRINGIZE_I(x) x
#define NNT_CAPSRV_MAKERNOTE_STRINGIZE(x) NNT_CAPSRV_MAKERNOTE_STRINGIZE_I(#x)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_16 \
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_32 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_16 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_16

#define NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_64 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_32 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_32

#define NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_128 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_64 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_64

#define NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_256 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_128 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_128

#define NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_512 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_256 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_256

#define NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023 \
    0x04, 0xE1, 0xFE, 0x2A, 0xB9, 0xCD, 0xC4, 0xC3, 0x60, 0x32, 0xFF, 0x9B, 0x00, 0xF8, 0x07, 0x5E, 0xF9, 0xF0, 0x41, 0xEC, 0x95, 0x48, 0x90, 0x0D, 0x21, 0x0C, 0xF7, 0x98, 0xB9, 0xF7, 0xE6, 0x21, \
    0xEE, 0x90, 0xDA, 0x7E, 0x2C, 0x25, 0x92, 0x74, 0x71, 0x3F, 0xA9, 0x87, 0xA7, 0x45, 0x3C, 0xAA, 0xE4, 0x41, 0x9B, 0x17, 0x61, 0x89, 0xBE, 0xEF, 0xAD, 0x9E, 0x69, 0xBA, 0xDD, 0xB3, 0xB8, 0xC2, \
    0x2B, 0x7E, 0x27, 0x38, 0x59, 0xF9, 0x6B, 0xE7, 0x82, 0xF7, 0x57, 0x66, 0xE3, 0x37, 0x1F, 0x31, 0x06, 0x83, 0x9A, 0x0F, 0x92, 0x35, 0x77, 0x49, 0xB6, 0xA3, 0x69, 0xA4, 0xB9, 0x70, 0xA5, 0x35, \
    0x7C, 0xCD, 0x67, 0x5F, 0x6B, 0x91, 0x4A, 0x44, 0xD8, 0x05, 0xC7, 0x5A, 0xDC, 0x95, 0x5A, 0x0B, 0xC3, 0xFC, 0x68, 0x1A, 0x54, 0xC7, 0xCD, 0xE8, 0x8F, 0x3C, 0x7C, 0xAD, 0xDC, 0x98, 0xAD, 0x56, \
    0xE7, 0xFC, 0xDA, 0x67, 0x72, 0x5B, 0x35, 0xF0, 0x1F, 0xB1, 0xBB, 0x9A, 0x5D, 0x94, 0xD7, 0x25, 0x0D, 0xF3, 0x55, 0xC4, 0xA2, 0xD9, 0x19, 0x6A, 0xD3, 0x1B, 0x2E, 0xF5, 0x80, 0x28, 0x0A, 0xF4, \
    0x61, 0xED, 0x75, 0x72, 0x6B, 0xCC, 0x7A, 0xAA, 0x83, 0xDA, 0x04, 0xF5, 0xBC, 0xE6, 0xB8, 0x71, 0xEE, 0xB3, 0x9E, 0x39, 0x6C, 0xD6, 0x6E, 0x8C, 0xA7, 0x77, 0x74, 0xED, 0x4D, 0x67, 0xA1, 0x2C, \
    0x6F, 0x5D, 0x37, 0xC6, 0x45, 0xAF, 0x44, 0xC7, 0xB4, 0x5D, 0xBA, 0x3B, 0x58, 0xCD, 0xE8, 0x46, 0x8B, 0xE7, 0x1A, 0x94, 0xBD, 0xA1, 0x20, 0xC3, 0x17, 0x85, 0x52, 0x14, 0xC6, 0xE1, 0xD5, 0xCD, \
    0x53, 0x3D, 0xBC, 0xC7, 0x51, 0x4D, 0x49, 0x31, 0x8A, 0xD5, 0x99, 0xD6, 0x6E, 0x05, 0xC7, 0xC5, 0x89, 0x2A, 0xBB, 0xA5, 0xCC, 0xD7, 0x7C, 0x48, 0xE0, 0xB4, 0x77, 0x5D, 0xA0, 0xEA, 0x67, 0xDA, \
    0xAB, 0x6C, 0xE1, 0xAE, 0x4D, 0x0B, 0x53, 0xD7, 0x0B, 0x9B, 0x81, 0x8A, 0x53, 0x94, 0xDE, 0xDC, 0x7B, 0x98, 0x41, 0x1E, 0x35, 0x19, 0x79, 0x2D, 0xC4, 0x9E, 0xB2, 0x17, 0x4B, 0xCA, 0x98, 0xC8, \
    0xB6, 0x9F, 0xE8, 0xF1, 0xEB, 0xD0, 0xAE, 0x64, 0xD9, 0xA9, 0x21, 0xBB, 0x25, 0xD9, 0x4C, 0xE1, 0xC3, 0x62, 0xAB, 0xC7, 0x39, 0x80, 0x7E, 0xA3, 0x01, 0xAB, 0xA0, 0xB9, 0xD9, 0x19, 0x4A, 0x14, \
    0x59, 0x0C, 0xEC, 0x25, 0x7C, 0x66, 0x48, 0xCA, 0x76, 0xBD, 0x34, 0xAE, 0x01, 0xC0, 0x96, 0xE3, 0x2D, 0xAE, 0x5D, 0x45, 0xC7, 0x38, 0x96, 0xB4, 0x42, 0xFB, 0xC2, 0xB6, 0x37, 0x84, 0x24, 0x22, \
    0xD9, 0x7C, 0xA8, 0x02, 0x02, 0xED, 0x70, 0x15, 0x77, 0x7A, 0x10, 0x78, 0xB8, 0x4D, 0x4B, 0x82, 0x19, 0x92, 0x54, 0x94, 0x22, 0x61, 0x5A, 0xC1, 0xB3, 0xDE, 0x73, 0x47, 0x7E, 0xD4, 0xC0, 0xD5, \
    0xC7, 0xAF, 0x47, 0x72, 0x84, 0x00, 0xD9, 0x11, 0xED, 0xFC, 0x27, 0x58, 0x56, 0xCD, 0x57, 0x44, 0xFF, 0x11, 0xE3, 0x12, 0x8C, 0x0B, 0xDE, 0x42, 0x63, 0xD8, 0x89, 0x8A, 0x8C, 0xE4, 0x8B, 0x29, \
    0x2D, 0x2D, 0x49, 0xEF, 0xBA, 0xBE, 0x26, 0x96, 0x8B, 0x64, 0x60, 0x5B, 0x3A, 0x39, 0x05, 0x53, 0x8B, 0x5E, 0x39, 0xAA, 0xB9, 0x87, 0xA6, 0x4B, 0x99, 0x64, 0x13, 0xC0, 0x52, 0x75, 0x5B, 0xBF, \
    0x48, 0x3F, 0xFD, 0x2E, 0x53, 0x92, 0x55, 0x68, 0xA4, 0x9D, 0x43, 0xEF, 0x88, 0xB0, 0x6D, 0x9F, 0x29, 0x68, 0x39, 0xBD, 0xB6, 0x27, 0x82, 0x7A, 0x1A, 0x50, 0xD0, 0x8A, 0xEF, 0x6F, 0x4B, 0x07, \
    0x7D, 0x7F, 0xDA, 0xC0, 0x60, 0x60, 0x69, 0x5B, 0x01, 0xA6, 0xA0, 0x2A, 0xB9, 0xCE, 0xA9, 0xCE, 0x58, 0x72, 0x22, 0x56, 0xCB, 0x3A, 0x56, 0x4B, 0x4B, 0xC2, 0x23, 0x5C, 0x50, 0x91, 0xAE, 0x19, \
    0x2A, 0xA8, 0x5C, 0x0B, 0xB7, 0xE7, 0x58, 0x78, 0x71, 0x69, 0x9B, 0x6D, 0x00, 0x3A, 0xA1, 0xBE, 0x5E, 0x07, 0x5A, 0xBA, 0x7E, 0xF5, 0xB9, 0xEE, 0x93, 0xB4, 0x08, 0x71, 0x2C, 0xE7, 0xC3, 0x4B, \
    0x1F, 0xE5, 0xD8, 0x52, 0xD4, 0xA7, 0x94, 0x95, 0x35, 0x03, 0x2C, 0xB4, 0x83, 0x91, 0xE0, 0x66, 0x53, 0x80, 0xEB, 0xE7, 0x7F, 0x86, 0x7F, 0xE5, 0x79, 0xA9, 0xD8, 0x52, 0xF2, 0x57, 0x8F, 0x62, \
    0xB1, 0x4F, 0xBB, 0x6E, 0x07, 0xB6, 0xF6, 0xDA, 0xD8, 0x76, 0x41, 0x6F, 0xFA, 0x82, 0x68, 0x35, 0x5B, 0xB7, 0x98, 0x99, 0x74, 0xAB, 0x0C, 0xE7, 0x09, 0x23, 0xDB, 0xE1, 0x57, 0x44, 0x1B, 0x31, \
    0xB1, 0x81, 0x0B, 0x07, 0x78, 0x2E, 0x3E, 0x21, 0xD1, 0xD0, 0xE1, 0xF9, 0x64, 0xBE, 0xF3, 0x2E, 0x0E, 0x70, 0x07, 0x32, 0x15, 0xED, 0x52, 0x66, 0xEB, 0x38, 0x6A, 0xA3, 0x6F, 0xF1, 0xFC, 0x44, \
    0x5D, 0x1C, 0x7A, 0xE9, 0xC0, 0x82, 0x2C, 0x40, 0xA0, 0x81, 0x36, 0xF0, 0x0A, 0xE7, 0x0D, 0x06, 0xC0, 0x2B, 0x77, 0x26, 0x00, 0x81, 0x72, 0x86, 0x2A, 0x85, 0xAB, 0x07, 0x9C, 0x90, 0xF5, 0xCC, \
    0x4D, 0x99, 0x58, 0x3B, 0x64, 0x28, 0x11, 0x29, 0x6B, 0xB0, 0x0A, 0x8A, 0x83, 0xBC, 0x10, 0x72, 0xF3, 0x44, 0xE0, 0xE1, 0x0B, 0xC8, 0x75, 0xEE, 0x99, 0x5A, 0x9D, 0xD4, 0x5C, 0x3A, 0x8D, 0xDD, \
    0xD6, 0x9B, 0x12, 0xAD, 0x04, 0xEB, 0x4A, 0x20, 0x39, 0x19, 0xCC, 0x62, 0x3B, 0x72, 0x36, 0x2C, 0x41, 0x4D, 0x7E, 0xA0, 0xDC, 0x2C, 0x9F, 0xE9, 0xD7, 0x3F, 0x8D, 0x53, 0x34, 0xC0, 0x9F, 0x6B, \
    0xD3, 0x51, 0x09, 0xE3, 0x46, 0x30, 0x54, 0xEA, 0x87, 0x64, 0xD6, 0x81, 0xB5, 0xCF, 0xE4, 0x72, 0x70, 0xEC, 0x47, 0x72, 0x62, 0x0E, 0x61, 0x3D, 0x77, 0x70, 0x81, 0xFD, 0x8C, 0x82, 0xCA, 0xEA, \
    0x06, 0xDD, 0x84, 0x7D, 0x70, 0xF4, 0x78, 0xCC, 0xB5, 0xAF, 0xC9, 0x2B, 0x46, 0x29, 0x89, 0xC6, 0x8A, 0xAA, 0x4B, 0x7F, 0x01, 0x22, 0xF3, 0x73, 0xC1, 0xAD, 0xC8, 0x24, 0x23, 0x05, 0xA9, 0xC2, \
    0x04, 0x1A, 0xA3, 0xF7, 0xAB, 0xD8, 0x10, 0x23, 0x5A, 0x54, 0xFD, 0x71, 0x2C, 0x4D, 0xB8, 0x49, 0x23, 0xD0, 0xFB, 0xA3, 0x24, 0x98, 0xE9, 0x91, 0x26, 0x5C, 0x04, 0x31, 0x95, 0x13, 0x90, 0xC9, \
    0x87, 0x00, 0x02, 0xEF, 0x05, 0xE2, 0xF5, 0xFB, 0xB5, 0x29, 0x2D, 0xA2, 0x1B, 0xF9, 0xE2, 0x0E, 0xFA, 0xF7, 0x70, 0x67, 0x7D, 0x19, 0xFD, 0x5A, 0xAB, 0xF9, 0xB4, 0xA3, 0xB9, 0x3E, 0xD9, 0x77, \
    0x8E, 0x3C, 0xEB, 0xBB, 0xBA, 0xB1, 0x66, 0x2C, 0x0D, 0x10, 0xF1, 0xF0, 0xA7, 0x75, 0x75, 0x0A, 0x8C, 0x6D, 0xD9, 0x42, 0xC5, 0xFE, 0x9B, 0xCD, 0x7F, 0x7D, 0x3C, 0x3D, 0x4F, 0xE2, 0x6A, 0x62, \
    0xCE, 0x19, 0xDF, 0x88, 0x7C, 0x27, 0xC4, 0xA5, 0x1B, 0x0C, 0x86, 0x8C, 0xA1, 0x02, 0x17, 0x12, 0x8B, 0xF8, 0x39, 0x1F, 0xAD, 0x59, 0xED, 0x80, 0xDF, 0x82, 0xF6, 0x99, 0x1D, 0x9B, 0x1F, 0xA7, \
    0x5E, 0xB8, 0x99, 0x9F, 0xAC, 0x23, 0xAE, 0x19, 0x21, 0xAE, 0x5C, 0x8F, 0xA4, 0x31, 0x4C, 0xE7, 0x4C, 0xAD, 0x57, 0x6F, 0xA4, 0x3A, 0x09, 0xE3, 0x8E, 0x89, 0xEB, 0x2D, 0xB9, 0xBB, 0x77, 0x0D, \
    0xF6, 0x88, 0x00, 0x84, 0xFF, 0xD1, 0x07, 0x07, 0xC6, 0x3B, 0x85, 0x7A, 0x09, 0x00, 0x1A, 0x21, 0x24, 0xD9, 0xB6, 0xEC, 0xA8, 0x79, 0x0D, 0x3A, 0xAD, 0x76, 0x96, 0x0B, 0x53, 0x85, 0x28, 0x9A, \
    0xD3, 0x8D, 0xC7, 0x98, 0x3F, 0x40, 0x87, 0x9B, 0x2C, 0x78, 0xA2, 0xEE, 0xC2, 0xDB, 0x5E, 0x37, 0xCC, 0x33, 0x55, 0x9D, 0xDD, 0x4B, 0x25, 0x71, 0x70, 0xA1, 0x99, 0x28, 0xC3, 0x89, 0x6F,


//-----------
// バージョン
//-----------
#define NNT_CAPSRV_MAKERNOTE_BYTES_VERSION0  0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_VERSION1  0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_VERSION2  0x02, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_VERSION3  0x03, 0x00, 0x00, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_VERSION_UNKNOWN_0 0x02, 0x00, 0x00, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_VERSION_SHORT 0x02, 0x00, 0x00, 0x00,

//-----------
// パディング
//-----------
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_OK_VERSION1  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_NG1_VERSION1 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_NG2_VERSION1 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,

#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_OK_VERSION2  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_NG1_VERSION2 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_NG2_VERSION2 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,

#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_OK_VERSION3  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_NG1_VERSION3 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_PADDING_NG2_VERSION3 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,

//-----------
// 各バージョンのエントリー
//-----------

#define NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION0(macro) \
    macro (SIGNATURE)  \
    macro (ENCAPPID)

#define NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION1(macro)  \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION0(macro) \
    macro (DATETIME)   \
    macro (FILEDESC)   \
    macro (APPLETDATA) \
    macro (DATAWIDTH)  \
    macro (DATAHEIGHT) \
    macro (DATAORIENT) \
    macro (FRAMECOUNT) \
    macro (FRATENUMER) \
    macro (FRATEDENOM) \
    macro (DURATION)   \
    macro (KEYINTVL)   \

#define NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION2(macro)  \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION1(macro) \
    macro (COPYRIGHT)  \
    macro (UNEDIT)     \
    macro (UNEDITX)    \
    macro (UNEDITY)    \
    macro (UNEDITWIDTH) \
    macro (UNEDITHEIGHT) \
    macro (APPLIDATA)  \
    macro (MOVIEWIDTH)  \
    macro (MOVIEHEIGHT) \

#define NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION3(macro)  \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION2(macro) \
    macro (SYSRSVINFO) \

#define NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_ALL(macro) NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION3(macro)


//-----------
// EntryTag
//-----------
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_SIGNATURE  0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_ENCAPPID   0x01, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_DATETIME   0x02, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_FILEDESC   0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_APPLETDATA 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_DATAWIDTH  0x06, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_DATAHEIGHT 0x07, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_DATAORIENT 0x08, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_FRAMECOUNT 0x09, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_FRATENUMER 0x0A, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_FRATEDENOM 0x0B, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_DURATION   0x0C, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_KEYINTVL   0x0D, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_COPYRIGHT  0x0E, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNEDIT       0x0F, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNEDITX      0x10, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNEDITY      0x11, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNEDITWIDTH  0x12, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNEDITHEIGHT 0x13, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_APPLIDATA    0x14, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_MOVIEWIDTH   0x15, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_MOVIEHEIGHT  0x16, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_SYSRSVINFO   0x17, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNKNOWN_0  0x03, 0x00,  // Ver0 用
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNKNOWN_1  0x15, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNKNOWN_2  0xFF, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_UNKNOWN_3  0xFF, 0xFF,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_SHORT      0x00,

//-----------
// EntrySize
//-----------
// 正しいサイズ
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_SIGNATURE  0x10, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_ENCAPPID   0x10, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_DATETIME   0x08, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_FILEDESC   0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_APPLETDATA 0x00, 0x04,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_DATAWIDTH  0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_DATAHEIGHT 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_DATAORIENT 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_FRAMECOUNT 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_FRATENUMER 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_FRATEDENOM 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_DURATION   0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_KEYINTVL   0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_COPYRIGHT  0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_UNEDIT       0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_UNEDITX      0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_UNEDITY      0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_UNEDITWIDTH  0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_UNEDITHEIGHT 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_APPLIDATA    0x04, 0x04,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_RESERVED     0x98, 0x03,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_MOVIEWIDTH  0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_MOVIEHEIGHT 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_SYSRSVINFO 0x00, 0x04,
// 1 短い
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_SIGNATURE  0x0F, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_ENCAPPID   0x0F, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_DATETIME   0x07, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_FILEDESC   0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_APPLETDATA 0xFF, 0x03,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_DATAWIDTH  0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_DATAHEIGHT 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_DATAORIENT 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_FRAMECOUNT 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_FRATENUMER 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_FRATEDENOM 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_DURATION   0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_KEYINTVL   0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_COPYRIGHT  0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_UNEDIT       0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_UNEDITX      0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_UNEDITY      0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_UNEDITWIDTH  0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_UNEDITHEIGHT 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_APPLIDATA    0x03, 0x04,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_RESERVED     0x97, 0x03,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_MOVIEWIDTH  0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_MOVIEHEIGHT 0x03, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_SYSRSVINFO 0xFF, 0x03,
// 1 長い
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_SIGNATURE  0x11, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_ENCAPPID   0x11, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_DATETIME   0x09, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_FILEDESC   0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_APPLETDATA 0x01, 0x04,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_DATAWIDTH  0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_DATAHEIGHT 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_DATAORIENT 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_FRAMECOUNT 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_FRATENUMER 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_FRATEDENOM 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_DURATION   0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_KEYINTVL   0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_COPYRIGHT  0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_UNEDIT       0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_UNEDITX      0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_UNEDITY      0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_UNEDITWIDTH  0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_UNEDITHEIGHT 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_APPLIDATA    0x05, 0x04,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_MOVIEWIDTH  0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_MOVIEHEIGHT 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_SYSRSVINFO 0x01, 0x04,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT         0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_ZERO          0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_HUGE          0xFF, 0xFF,

//-----------
// EntryBody
//-----------
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_SIGNATURE    0x19, 0x46, 0xBA, 0x4C, 0xB8, 0x40, 0x4C, 0x3C, 0xB7, 0x3E, 0x8A, 0xEE, 0x11, 0x8E, 0x68, 0x30,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_SIGNATURE 0x19, 0x46, 0xBA, 0x4C, 0xB8, 0x40, 0x4C, 0x3C, 0xB7, 0x3E, 0x8A, 0xEE, 0x11, 0x8E, 0x68,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_SIGNATURE  0x19, 0x46, 0xBA, 0x4C, 0xB8, 0x40, 0x4C, 0x3C, 0xB7, 0x3E, 0x8A, 0xEE, 0x11, 0x8E, 0x68, 0x30, 0xFA,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_ENCAPPID    0x40, 0x46, 0x7B, 0x60, 0xDC, 0x27, 0x45, 0x99, 0x8E, 0xFA, 0xA8, 0x9D, 0xBE, 0x88, 0xCB, 0x28,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_ENCAPPID 0x40, 0x46, 0x7B, 0x60, 0xDC, 0x27, 0x45, 0x99, 0x8E, 0xFA, 0xA8, 0x9D, 0xBE, 0x88, 0xCB,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_ENCAPPID  0x40, 0x46, 0x7B, 0x60, 0xDC, 0x27, 0x45, 0x99, 0x8E, 0xFA, 0xA8, 0x9D, 0xBE, 0x88, 0xCB, 0x28, 0x4A,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_DATETIME    0x37, 0x31, 0xE5, 0xE1, 0x0D, 0xE8, 0x2F, 0x77,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_DATETIME 0x37, 0x31, 0xE5, 0xE1, 0x0D, 0xE8, 0x2F,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_DATETIME  0x37, 0x31, 0xE5, 0xE1, 0x0D, 0xE8, 0x2F, 0x77, 0x90,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_FILEDESC    0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_FILEDESC 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_FILEDESC  0x01, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_FILEDESC (1) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_APPLETDATA    NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023 0xEF,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_APPLETDATA NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_APPLETDATA  NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023 0xEF, 0x01,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_DATAWIDTH    0x00, 0x05, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_DATAWIDTH 0x00, 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_DATAWIDTH  0x00, 0x05, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_DATAWIDTH (1280) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_DATAHEIGHT    0xD0, 0x02, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_DATAHEIGHT 0xD0, 0x02, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_DATAHEIGHT  0xD0, 0x02, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_DATAHEIGHT (720) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_DATAORIENT    0x02, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_DATAORIENT 0x02, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_DATAORIENT  0x02, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_DATAORIENT (2) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_FRAMECOUNT    0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_FRAMECOUNT 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_FRAMECOUNT  0x01, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_FRAMECOUNT (1) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_FRATENUMER    0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_FRATENUMER 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_FRATENUMER  0x01, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_FRATENUMER (1) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_FRATEDENOM    0x1E, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_FRATEDENOM 0x1E, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_FRATEDENOM  0x1E, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_FRATEDENOM (30) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_DURATION    0xA5, 0xB6, 0xE9, 0x7B,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_DURATION 0xA5, 0xB6, 0xE9,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_DURATION  0xA5, 0xB6, 0xE9, 0x7B, 0x8E,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_DURATION (2078914213) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_KEYINTVL      0x3C, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_KEYINTVL   0x3C, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_KEYINTVL    0x3C, 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_KEYINTVL (60) //NOLINT(preprocessor/const)


#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_COPYRIGHT    0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_COPYRIGHT 0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_COPYRIGHT  0x00, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_COPYRIGHT    (0) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_UNEDIT      0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_UNEDIT   0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_UNEDIT    0x01, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_UNEDIT      (1) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_UNEDITX     0x40, 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_UNEDITX  0x40, 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_UNEDITX   0x40, 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_UNEDITX (320) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_UNEDITY     0xB4, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_UNEDITY  0xB4, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_UNEDITY   0xB4, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_UNEDITY (180) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_UNEDITWIDTH     0x80, 0x02, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_UNEDITWIDTH  0x80, 0x02, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_UNEDITWIDTH   0x80, 0x02, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_UNEDITWIDTH (640) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_UNEDITHEIGHT     0x68, 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_UNEDITHEIGHT  0x68, 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_UNEDITHEIGHT   0x68, 0x01, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_UNEDITHEIGHT (360) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_APPLIDATA     NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023 0xEF, 0x00, 0x04, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_APPLIDATA  NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023 0xEF, 0x00, 0x04, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_APPLIDATA   NNT_CAPSRV_MAKERNOTE_BYTES_RANDOM_1023 0xEF, 0x00, 0x04, 0x00, 0x00, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_MOVIEWIDTH    0x00, 0x05, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_MOVIEWIDTH 0x00, 0x05, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_MOVIEWIDTH  0x00, 0x05, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_MOVIEWIDTH (1280) //NOLINT(preprocessor/const)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_MOVIEHEIGHT    0xD0, 0x02, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_MOVIEHEIGHT 0xD0, 0x02, 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_MOVIEHEIGHT  0xD0, 0x02, 0x00, 0x00, 0x00,
#define NNT_CAPSRV_MAKERNOTE_VALUE_ENTRYBODY_OK_MOVIEHEIGHT (720) //NOLINT(preprocessor/const)


#define NNT_CAPSRV_MAKERNOTE_BYTES_UID(lastbyte) \
    0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, lastbyte,
#define NNT_CAPSRV_MAKERNOTE_BYTES_UID_COUNT(count) \
    count, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_SYSRSVINFO_1023 \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(1) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(2) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(3) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(4) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(5) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(6) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(7) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID(8) \
            NNT_CAPSRV_MAKERNOTE_BYTES_UID_COUNT(8) \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_512 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_256 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_64 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_32 \
            NNT_CAPSRV_MAKERNOTE_BYTES_ZEROS_16 \
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_SYSRSVINFO    NNT_CAPSRV_MAKERNOTE_BYTES_SYSRSVINFO_1023 0x00,
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_SYSRSVINFO NNT_CAPSRV_MAKERNOTE_BYTES_SYSRSVINFO_1023
#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_SYSRSVINFO  NNT_CAPSRV_MAKERNOTE_BYTES_SYSRSVINFO_1023 0x00, 0x00,


//-----------
// IsOptional
//-----------
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_SIGNATURE    false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_ENCAPPID     false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_DATETIME     false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_FILEDESC     false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_APPLETDATA   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_DATAWIDTH    false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_DATAHEIGHT   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_DATAORIENT   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_FRAMECOUNT   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_FRATENUMER   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_FRATEDENOM   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_DURATION     false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_KEYINTVL     false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_COPYRIGHT    false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_UNEDIT       false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_UNEDITX      false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_UNEDITY      false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_UNEDITWIDTH  false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_UNEDITHEIGHT false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_APPLIDATA    false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_MOVIEWIDTH   false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_MOVIEHEIGHT  false //NOLINT(preprocessor/const)
#define NNT_CAPSRV_MAKERNOTE_IS_OPTIONAL_SYSRSVINFO   false //NOLINT(preprocessor/const)

//-----------
// エントリー
//-----------

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_OK(NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_, NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_OK_, NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_OK_, NAME)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_SHORT(NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_, NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_SHORT_, NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_SHORT_, NAME)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_LONG(NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYTAG_, NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYSIZE_LONG_, NAME) \
    NNT_CAPSRV_MAKERNOTE_CONCAT(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYBODY_LONG_, NAME)

//-----------
// 正しい入力
//-----------

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYLIST_OK_VERSION0    \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION0(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_OK)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYLIST_OK_VERSION1  \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION1(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_OK)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYLIST_OK_VERSION2  \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION2(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_OK)

#define NNT_CAPSRV_MAKERNOTE_BYTES_ENTRYLIST_OK_VERSION3  \
    NNT_CAPSRV_MAKERNOTE_FOREACH_ENTRY_VERSION3(NNT_CAPSRV_MAKERNOTE_BYTES_ENTRY_OK)
