﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/mem/mem_StandardAllocator.h>

#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_CaptureModule.h"
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_MemoryPool.h"
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_ImageBuffer.h"
#include <nn/gfx/util/gfx_TransientMemoryPoolAllocatorHolder.h>

#include "testCapsrv_Static.h"

static const int RepeatCount = 1000;

TEST(ImageBuffer, InitializeFinalize)
{

    nn::capsrv::capture::InitializeCaptureModule();
    auto pModule = nn::capsrv::capture::GetCaptureModule();
    nn::capsrv::capture::MemoryPool pool;
    NN_ABORT_UNLESS_RESULT_SUCCESS(pool.Initialize(pModule, g_Storage, sizeof(g_Storage)));

    NN_LOG("setup info\n");
    nn::capsrv::capture::ImageBufferInfo info;
    info.width = 1280;
    info.height = 720;
    info.format = nn::capsrv::capture::ImageFormat_Rgba8;
    size_t size = nn::capsrv::capture::ImageBuffer::GetRequiredMemorySize(info);
    size_t alignment = nn::capsrv::capture::ImageBuffer::GetRequiredMemoryAlignment(pModule, info);
    NN_LOG("  size  : %llu\n", size);
    NN_LOG("  align : %llu\n", alignment);

    nn::gfx::MemoryPool memoryPool; // ダミー
    nn::gfx::util::TransientMemoryPoolAllocatorHolder<2> poolAllocatorHolder;
    poolAllocatorHolder.Initialize(&memoryPool, 0, sizeof(g_Storage), nn::gfx::util::TransientMemoryPoolAllocator::AlignmentMax);
    auto pPoolAllocator = poolAllocatorHolder.Get();
    pPoolAllocator->FillHistory();

    auto f = [&](){
        pPoolAllocator->Free();
        pPoolAllocator->Begin();
        auto offset = pPoolAllocator->Allocate(size, alignment);
        NN_ASSERT_GREATER_EQUAL(offset, 0);
        nn::capsrv::capture::ImageBuffer img;
        img.Initialize(pModule, info, &pool, offset, size);
        img.Finalize();
        pPoolAllocator->End();
    };

    NN_LOG("first initializing-finalizing\n");
    f();

    size_t freeMemoryAfterFirst = g_GraphicsAllocator.GetTotalFreeSize();

    NN_LOG("repeat initializing-finalizing\n");
    for(int i = 0; i < RepeatCount; i++)
    {
        if(i % 100 == 0)
        {
            NN_LOG("  %d-th loop\n", i);
        }
        f();
    }


    size_t freeMemoryAfterRepeat = g_GraphicsAllocator.GetTotalFreeSize();

    NN_LOG("free memory:\n  after first %llu\n  after repeat %llu\n", freeMemoryAfterFirst, freeMemoryAfterRepeat);
    // 多分同じになる
    EXPECT_EQ(freeMemoryAfterFirst, freeMemoryAfterRepeat);

    poolAllocatorHolder.Finalize();
    pool.Finalize();
    nn::capsrv::capture::FinalizeCaptureModule();

}
