﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi.h>
#include <nn/vi/buffer/vi_Buffer.h>

namespace nnt{ namespace capsrv{

    class TargetImageRenderer
    {
    public:
        static const int Width = 1280;
        static const int Height = 720;
        static const nn::vi::PixelFormat Format = nn::vi::PixelFormat_Rgba8888;
        static const int BufferCount = 2;
    public:
        TargetImageRenderer() NN_NOEXCEPT;
        ~TargetImageRenderer() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void Present(const void* pData, size_t size) NN_NOEXCEPT;

    private:
        void FinalizeImpl() NN_NOEXCEPT;

    private:
        bool m_IsInitialized;
        nn::vi::Display* m_pDisplay;
        nn::vi::Layer* m_pLayer;
        nn::vi::buffer::BufferQueue m_Queue;

        // 出画バッファのメモリ。
        NN_ALIGNAS(4096) char m_Memory[2][4 * 1024 * 1024];
    };

}}

