﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>
#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/movie/capsrv_CachedMovieStream.h>

#define NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR(...) NN_LOG(__VA_ARGS__)

#ifndef NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR
#define NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR(...)
#endif


namespace nnt{ namespace capsrv{ namespace detail{

    struct TestMovieStreamAccessor
    {
    public:
        static nn::Result Read(size_t* pOutReadSize, void* buffer, size_t size, int64_t offset, void* userData) NN_NOEXCEPT
        {
            NN_ASSERT_GREATER_EQUAL(offset, 0);
            NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR("=> r: %llu-%llu\n", offset, offset + size);
            auto pSelf = reinterpret_cast<TestMovieStreamAccessor*>(userData);

            std::memset(buffer, 0, size);

            ptrdiff_t beg = std::max<ptrdiff_t>(0, static_cast<ptrdiff_t>(offset));
            ptrdiff_t end = std::min<ptrdiff_t>(pSelf->data.size(), static_cast<ptrdiff_t>(offset) + size);
            if(beg < end)
            {
                std::memcpy(buffer, pSelf->data.data() + beg, end - beg);
            }

            *pOutReadSize = size;
            NN_RESULT_SUCCESS;
        }

        static nn::Result Write(int64_t offset, const void* buffer, size_t size, void* userData) NN_NOEXCEPT
        {
            NN_ASSERT_GREATER_EQUAL(offset, 0);
            if(size == 0)
            {
                NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR("<= w: ignore zero size write\n");
                NN_RESULT_SUCCESS;
            }
            NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR("<= w: %llu-%llu\n", offset, offset + size);
            auto pSelf = reinterpret_cast<TestMovieStreamAccessor*>(userData);

            if(pSelf->data.size() < static_cast<size_t>(offset) + size)
            {
                pSelf->data.resize(static_cast<size_t>(offset) + size);
            }
            std::memcpy(pSelf->data.data() + static_cast<ptrdiff_t>(offset), buffer, size);
            NN_RESULT_SUCCESS;
        }

        static nn::Result Shrink(int64_t size, void* userData) NN_NOEXCEPT
        {
            NNT_CAPSRV_LOG_MOVIESTREAMACCESSOR("<> shrink: %llu\n", size);
            auto pSelf = reinterpret_cast<TestMovieStreamAccessor*>(userData);
            pSelf->data.resize(static_cast<size_t>(size));
            NN_RESULT_SUCCESS;
        }

        nn::capsrv::movie::MovieStreamAccessor GetAccessor() NN_NOEXCEPT
        {
            nn::capsrv::movie::MovieStreamAccessor accessor = {};
            accessor.userData = this;
            accessor.read = Read;
            accessor.write = Write;
            accessor.shrink = Shrink;
            return accessor;
        }

    public:
        std::vector<uint8_t> data;
    };

}}}
