﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/bluetooth_Client.h"
#include <nn/bluetooth/bluetooth_Result.public.h>
#include <nn/bluetooth/bluetooth_Result.private.h>

#include <cstring>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

class fatalErrorRecoveryTestClient : public bluetoothClient
{
    public:
    private:
};


static fatalErrorRecoveryTestClient client;
/*******************************************************************************
* nnMain()
*******************************************************************************/
extern "C" void nnMain()
{
    NN_LOG("\nFatalErrorRecovery Test Now Running \n");

    client.startBluetooth();
    nn::bluetooth::ExtSetVisibility(false,true);

    int loopTimeMs=0;
    int i=0;

    while(i < 1000)
    {
        if(loopTimeMs==0)
        {
            //Discovery
            NN_LOG("  [StartDiscovery]\n");
            nn::bluetooth::StartDiscovery();
        }

        if(loopTimeMs==15000)
        {
            NN_LOG("Turning off bluetooth\n");
            nn::bluetooth::CancelBond(&client.controllerInfo[0].bdAddr);
        }

        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(100));
        loopTimeMs += 100;
        if(loopTimeMs == 30000)
        {
           loopTimeMs=0;
        }

        if (client.fatalErrorOccurred)
        {
            client.restartBluetooth();
            client.fatalErrorOccurred = false;

            NN_LOG("\n-----------------------------------------------------------------------\n");
            NN_LOG("Iteration %d\n", ++i);
        }
    }

    client.finishBluetooth();

    SUCCEED();
}
