﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/bluetooth_Client.h"
#include <nn/bluetooth/bluetooth_Result.public.h>
#include <nn/bluetooth/bluetooth_Result.private.h>

#include <cstring>
#include <cstdlib>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

enum {DISCOVERY_INTERVAL_MS = 20000};
enum {SET_TSI_INTERVAL_MS = 5000};

class setTsiTestClient : public bluetoothClient
{
    public:

    int goalTsi = 10;

    private:

};

/*******************************************************************************
* randomInRange()
*******************************************************************************/
int randomInRange(int min, int max)
{
    return ((rand()>>4) % (max + 1 - min)) + min;
}

static setTsiTestClient client;
/*******************************************************************************
* nnMain()
*******************************************************************************/
extern "C" void nnMain()
{
    NN_LOG("\nWakeControllerTestClient NOW RUNNING \n");

    client.startBluetooth();
    nn::bluetooth::ExtSetVisibility(false,true);

    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(3000));

    int loopTimeMs=0;
    int loops = 0;

    while (1)
    {
        if ((loopTimeMs % DISCOVERY_INTERVAL_MS) == 0)
        {
            loops++;
            NN_LOG("\n-----------------------------------------------------------------------\n");
            NN_LOG("  [StartDiscovery %d]\n", loops);
            nn::bluetooth::StartDiscovery();

            if (loops > 100)
            {
                break;
            }
        }

        if ((loopTimeMs % SET_TSI_INTERVAL_MS) == 0)
        {
            // Set sniff-mode connected controllers to active mode.
            int connectedControllers = 0;
            for (int i=0; i<bluetoothClient::MAX_CTRL; i++)
            {
                if (client.controllerInfo[i].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED
                        && client.controllerInfo[i].valid
                        && client.controllerInfo[i].tsi != 0xFF
                        && client.controllerInfo[i].tsiChangeAcked)
                {
                    client.setTsi(client.controllerInfo[i].bdAddr, 0xFF);
                    connectedControllers++;
                }
            }

            // Set new target TSI
            if      (connectedControllers > 6) client.goalTsi = randomInRange(9,10);
            else if (connectedControllers > 4) client.goalTsi = randomInRange(7,10);
            else if (connectedControllers > 2) client.goalTsi = randomInRange(1,10);
            else                               client.goalTsi = randomInRange(0,10);

        }

        // Set active-mode connected controllers to sniff mode.
        for (int i=0; i<bluetoothClient::MAX_CTRL; i++)
        {
            if (client.controllerInfo[i].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED
                    && client.controllerInfo[i].valid
                    && client.controllerInfo[i].tsi == 0xFF
                    && client.controllerInfo[i].tsiChangeAcked)
            {
                client.setTsi(client.controllerInfo[i].bdAddr, client.goalTsi);
            }
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
        loopTimeMs += 100;
    }

    NN_LOG("\n-----------------------------------------------------------------------\n");
    NN_LOG("Exiting test\n");
    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000));
    client.finishBluetooth();

    SUCCEED();
}
