﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/bluetooth_Client.h"
#include <nn/bluetooth/bluetooth_Result.public.h>
#include <nn/bluetooth/bluetooth_Result.private.h>

#include <cstring>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

class setConfigTestClient : public bluetoothClient
{
    public:
    private:
};

static setConfigTestClient client;
/*******************************************************************************
* nnMain()
*******************************************************************************/
extern "C" void nnMain()
{
    NN_LOG("\n setConfigTestClient NOW RUNNING \n");

    int64_t t1, t2;

    client.startBluetooth();
    nn::bluetooth::ExtSetVisibility(false,true);

    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(5000));
    //nn::bluetooth::StartDiscovery();

    for(int k=0; k<10; k++)
    {
        nn::Result result;
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Iteration %d\n", k);

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Start LLR scan\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::ExtStartLlrMode();
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] ExtStartLlrMode returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] ExtStartLlrMode returned after (%lld ms)\n", t2 - t1);
        }

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Resume active mode\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::ExtExitLlrMode();
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] ExtExitLlrMode returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] ExtExitLlrMode returned after (%lld ms)\n", t2 - t1);
        }

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Set radio off\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::ExtSetRadio(false);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] ExtSetRadio returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] ExtSetRadio returned after (%lld ms)\n", t2 - t1);
        }

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Set radio on\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::ExtSetRadio(true);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] ExtSetRadio returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] ExtSetRadio returned after (%lld ms)\n", t2 - t1);
        }

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Set Mc Mode off\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::ExtSetMcMode(false);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] ExtSetMcMode returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] ExtSetMcMode returned after (%lld ms)\n", t2 - t1);
        }

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Set Mc Mode on\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::ExtSetMcMode(true);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] ExtSetMcMode returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] ExtSetMcMode returned after (%lld ms)\n", t2 - t1);
        }

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Set super address\n");
        nn::bluetooth::Btbdaddr bluetoothSuperAddress = {{0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc}};
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        result = nn::bluetooth::SetAdapterProperty(nn::bluetooth::BT_PROPERTY_SUPER_BDADDR, bluetoothSuperAddress.address, 6);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        if (result.IsFailure())
        {
            NN_LOG("\t\t[FAIL] SetAdapterProperty returned result %d, should be 0\n", result.GetDescription());
        }
        else
        {
            NN_LOG("\t\t[PASS] SetAdapterProperty returned after (%lld ms)\n", t2 - t1);
        }
    }

    nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000));
    client.finishBluetooth();

    SUCCEED();
} //NOLINT(impl/function_size)
