﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testBcat_Common.h"

#include <nn/bcat/detail/service/core/bcat_PassphraseManager.h>

using namespace nn::bcat::detail::service::core;

namespace
{
    const nn::ApplicationId AppId = {0x0100db60000a8000};
}

TEST(PassphraseManager, Initialize)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHost("bcat-dc-00", "C:\\siglo\\bcat-dc-00"));
    DeliveryCacheStorageManager::GetInstance().EnableTestMode();

    ASSERT_RESULT_SUCCESS(DeliveryCacheStorageManager::GetInstance().Mount(AppId));
}

TEST(PassphraseManager, Save)
{
    char passphrase1[nn::bcat::PassphraseLengthMax + 1] = {"x"};
    char passphrase2[nn::bcat::PassphraseLengthMax + 1] = {"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"};

    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(AppId, passphrase1));
    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(AppId, passphrase1));
    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(AppId, passphrase2));
    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(AppId, passphrase2));
}

TEST(PassphraseManager, Get)
{
    char passphrase[nn::bcat::PassphraseLengthMax + 1] = {};

    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Get(passphrase, sizeof (passphrase), AppId));
    EXPECT_TRUE(nn::util::Strncmp(passphrase, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", nn::bcat::PassphraseLengthMax + 1) == 0);
}

TEST(PassphraseManager, Delete)
{
    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Delete(AppId));
    ASSERT_RESULT_SUCCESS(PassphraseManager::GetInstance().Delete(AppId));
}

TEST(PassphraseManager, Temporary)
{
    for (int i = 0; i < PassphraseManager::TemporaryCountMax; i++)
    {
        nn::ApplicationId appId = {static_cast<nn::Bit64>(i + 1)};

        ASSERT_TRUE(PassphraseManager::GetInstance().AddTemporary(appId, "x"));
    }

    {
        nn::ApplicationId appId = {static_cast<nn::Bit64>(PassphraseManager::TemporaryCountMax + 1)};

        ASSERT_FALSE(PassphraseManager::GetInstance().AddTemporary(appId, "x"));
    }

    for (int i = 0; i < PassphraseManager::TemporaryCountMax; i++)
    {
        nn::ApplicationId appId = {static_cast<nn::Bit64>(i + 1)};

        PassphraseManager::GetInstance().RemoveTemporary(appId);
    }

    {
        nn::ApplicationId appId = {static_cast<nn::Bit64>(1)};

        ASSERT_TRUE(PassphraseManager::GetInstance().AddTemporary(appId, "x"));
        PassphraseManager::GetInstance().RemoveTemporary(appId);
    }
}
