﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ConvNpad.h"

namespace nnt { namespace applet { namespace hid {

    void InitializeConvNpad()
    {
        nn::hid::InitializeDebugPad();

        static const nn::hid::NpadIdType NpadIds[] =
        {
            nn::hid::NpadId::No1,
            nn::hid::NpadId::No2,
            nn::hid::NpadId::No3,
            nn::hid::NpadId::No4,
            nn::hid::NpadId::No5,
            nn::hid::NpadId::No6,
            nn::hid::NpadId::No7,
            nn::hid::NpadId::No8,
            nn::hid::NpadId::Handheld
        };

        nn::hid::InitializeNpad();
        nn::hid::SetSupportedNpadIdType(NpadIds, sizeof(NpadIds) / sizeof(NpadIds[0]));
        nn::hid::SetSupportedNpadStyleSet(
            nn::hid::NpadStyleHandheld::Mask |
            nn::hid::NpadStyleFullKey::Mask |
            nn::hid::NpadStyleJoyDual::Mask |
            nn::hid::NpadStyleJoyLeft::Mask |
            nn::hid::NpadStyleJoyRight::Mask
        );

        nn::hid::SetNpadHandheldActivationMode(nn::hid::NpadHandheldActivationMode_Single);
    }

    void GetConvNpadState(nn::hid::DebugPadState* pOutDebugPadState)
    {
        NN_ASSERT_NOT_NULL(pOutDebugPadState);

        static const nn::hid::NpadIdType NpadIds[] =
        {
            nn::hid::NpadId::No1,
            nn::hid::NpadId::No2,
            nn::hid::NpadId::No3,
            nn::hid::NpadId::No4,
            nn::hid::NpadId::No5,
            nn::hid::NpadId::No6,
            nn::hid::NpadId::No7,
            nn::hid::NpadId::No8,
            nn::hid::NpadId::Handheld
        };

        nn::hid::DebugPadState resultState = { NULL };

        // DebugPad のステータス取得します
        nn::hid::GetDebugPadState(&resultState);

        // Npad のボタン入力と合体します
        {
            const int maxIndex = nn::hid::NpadStyleJoyRight::Index;
            nn::hid::NpadButtonSet buttonSet;
            buttonSet.Reset();
            for (int i = 0; i < (sizeof(NpadIds) / sizeof(NpadIds[0])); ++i)
            {
                nn::hid::NpadStyleSet styleSet = nn::hid::GetNpadStyleSet(NpadIds[i]);
                if (styleSet.IsAllOff()) { continue; }
                for (int j = 0; j < maxIndex; ++j)
                {
                    if (styleSet.Test(j))
                    {
                        switch (j)
                        {
                        case nn::hid::NpadStyleHandheld::Index:
                        {
                            nn::hid::NpadHandheldState tempState = { NULL };
                            nn::hid::GetNpadState(&tempState, NpadIds[i]);
                            buttonSet |= tempState.buttons;
                            break;
                        }
                        case nn::hid::NpadStyleFullKey::Index:
                        {
                            nn::hid::NpadFullKeyState tempState = { NULL };
                            nn::hid::GetNpadState(&tempState, NpadIds[i]);
                            buttonSet |= tempState.buttons;
                            break;
                        }
                        case nn::hid::NpadStyleJoyDual::Index:
                        {
                            nn::hid::NpadJoyDualState tempState = { NULL };
                            nn::hid::GetNpadState(&tempState, NpadIds[i]);
                            buttonSet |= tempState.buttons;
                            break;
                        }
                        case nn::hid::NpadStyleJoyLeft::Index:
                        {
                            nn::hid::NpadJoyLeftState tempState = { NULL };
                            nn::hid::GetNpadState(&tempState, NpadIds[i]);
                            buttonSet |= tempState.buttons;
                            break;
                        }
                        case nn::hid::NpadStyleJoyRight::Index:
                        {
                            nn::hid::NpadJoyRightState tempState = { NULL };
                            nn::hid::GetNpadState(&tempState, NpadIds[i]);
                            buttonSet |= tempState.buttons;
                            break;
                        }
                        default:
                            continue;
                            break;
                        }
                    }
                }
            }
            // Npadのボタン入力をDebugPadのボタン入力に変換します
            if (buttonSet.IsAnyOn())
            {
                nn::hid::DebugPadButtonSet convButton;
                convButton.Reset();
                convButton.Set<nn::hid::DebugPadButton::A>(buttonSet.Test<nn::hid::NpadButton::A>());
                convButton.Set<nn::hid::DebugPadButton::B>(buttonSet.Test<nn::hid::NpadButton::B>());
                convButton.Set<nn::hid::DebugPadButton::X>(buttonSet.Test<nn::hid::NpadButton::X>());
                convButton.Set<nn::hid::DebugPadButton::Y>(buttonSet.Test<nn::hid::NpadButton::Y>());
                convButton.Set<nn::hid::DebugPadButton::L>(buttonSet.Test<nn::hid::NpadButton::L>());
                convButton.Set<nn::hid::DebugPadButton::R>(buttonSet.Test<nn::hid::NpadButton::R>());
                convButton.Set<nn::hid::DebugPadButton::ZL>(buttonSet.Test<nn::hid::NpadButton::ZL>());
                convButton.Set<nn::hid::DebugPadButton::ZR>(buttonSet.Test<nn::hid::NpadButton::ZR>());
                convButton.Set<nn::hid::DebugPadButton::Start>(buttonSet.Test<nn::hid::NpadButton::Plus>());
                convButton.Set<nn::hid::DebugPadButton::Select>(buttonSet.Test<nn::hid::NpadButton::Minus>());
                convButton.Set<nn::hid::DebugPadButton::Up>(buttonSet.Test<nn::hid::NpadButton::Up>());
                convButton.Set<nn::hid::DebugPadButton::Down>(buttonSet.Test<nn::hid::NpadButton::Down>());
                convButton.Set<nn::hid::DebugPadButton::Left>(buttonSet.Test<nn::hid::NpadButton::Left>());
                convButton.Set<nn::hid::DebugPadButton::Right>(buttonSet.Test<nn::hid::NpadButton::Right>());
                resultState.buttons |= convButton;
            }
        }
        *pOutDebugPadState = resultState;
    }

}}} // nnt::applet::hid
