﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/npnsUtil.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>

#include <nn/aoc/aoc_SystemApi.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>

#include <nn/lr/lr_Service.h>
#include <nn/lr/lr_AddOnContentLocationResolver.h>

using namespace nn;

namespace {

    class PrepareAddOnContentTest : public testing::Test
    {
    public:
    protected:

        static void SetUpTestCase()
        {
            nn::aoc::Initialize();
            lr::Initialize();
            ncm::Initialize();
        }

        static void TearDownTestCase()
        {
            ncm::Finalize();
            lr::Finalize();
            nn::aoc::Finalize();
        }

    };

} // namespace


NN_OS_ALIGNAS_THREAD_STACK nn::Bit8 g_DispatcherStack[16 * 1024];

struct TestSpec
{
    aoc::AddOnContentIndex index;
    ncm::DataId dataId;
    ncm::StorageId storage;
};

// 0x0100cb5000003001, Nand: v1, Sd: -
// 0x0100cb5000003002, Nand: - , Sd: v1
// 0x0100cb5000003003, Nand: v1, Sd: v1
TestSpec specs[] = {
    { 1, { 0x0100cb5000003001 }, ncm::StorageId::BuildInUser },
    { 2, { 0x0100cb5000003002 }, ncm::StorageId::SdCard },
    { 3, { 0x0100cb5000003003 }, ncm::StorageId::SdCard },
};

TEST_F(PrepareAddOnContentTest, Basic)
{
    lr::AddOnContentLocationResolver ar;
    NNT_EXPECT_RESULT_SUCCESS(nn::lr::OpenAddOnContentLocationResolver(&ar));

    for (auto spec : specs)
    {
        NN_LOG("----------------------------------------------\n", spec.index);
        NN_LOG("ContentIndex: %d\n", spec.index);
        NN_LOG("DataId      : %16llx\n", spec.dataId);
        NN_LOG("Storage     : %s\n", spec.storage == ncm::StorageId::BuildInUser ? "Nand" : "Sd");
        NNT_EXPECT_RESULT_SUCCESS(aoc::PrepareAddOnContent(spec.index));

        lr::Path path;
        NNT_ASSERT_RESULT_SUCCESS(ar.ResolveAddOnContentPath(&path, spec.dataId));

        ncm::ContentMetaDatabase db;
        NNT_ASSERT_RESULT_SUCCESS(ncm::OpenContentMetaDatabase(&db, spec.storage));

        ncm::ContentId contentId;
        NNT_ASSERT_RESULT_SUCCESS(db.GetLatestData(&contentId, spec.dataId));

        ncm::ContentStorage cs;
        NNT_ASSERT_RESULT_SUCCESS(ncm::OpenContentStorage(&cs, spec.storage));

        ncm::Path masterPath;
        cs.GetPath(&masterPath, contentId);

        EXPECT_STREQ(masterPath.string, path.string);
    }
}
