﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <nn/account/nas/account_NasTypes.h>

#include "testAccount_NasProxy.h"

nn::Result LinkNintendoAccount(
    const nnt::account::NasLoginInfo& loginInfo,
    nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
nn::Result LinkNintendoAccountWithSuspend(
    const nnt::account::NasLoginInfo& loginInfo,
    nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;

nn::Result UnlinkNintendoAccount(
    nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
