﻿# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals
from HACDllDriver import TmUtility, HACLogReaderDll

import ctypes
import sys
import time

"""
ログ取得ライブラリの機能を使用したのサンプルです。
TargetManager にて対象開発機へ接続してから実行する必要があります。
ログを出力するアプリケーションを起動しておくと動きが確認できます。
"""

def read_line(logreaderDll):
    bufSize = ctypes.c_size_t(0)
    if logreaderDll.GetLogLineSize(ctypes.pointer(bufSize)) == 0:
        buf = ctypes.create_string_buffer(bufSize.value)
        if logreaderDll.GetLogLine(buf, bufSize) == 0:
            print(buf.value.decode('utf-8'))

if __name__ == "__main__":
    # sys.argv[1] = 対象のシリアルナンバー
    serial_number = None
    if len(sys.argv) != 1:
        serial_number = sys.argv[1]

    tm_utility = TmUtility()
    log_reader = HACLogReaderDll()

    if serial_number is None:
        targets = tm_utility.get_connected_targets()
        if len( targets ) == 0:
            print("Connected target was not found")
            exit(0)

        serial_number = targets[0]
    
    log_reader.set_serial( serial_number )
    log_reader.open()

    logreader_dll = log_reader.get_dll()

    print("-----------------------------")
    print("Example for reading logs from application")

    # Wait for a new log
    for var in range(0, 10):
        if logreader_dll.WaitForNextLine(int(1000)) == 0:
            logreader_dll.MoveToNextLine()
            read_line(logreader_dll)
        else:
            print("New log was not found")

    time.sleep(5)

    # Wait for a new log matching the regular expression
    print("Print log after waiting for outputting specified text")
    key_string = r".*"
    logreader_dll.MoveToNewestLine()
    if logreader_dll.WaitUntilMatched(key_string.encode('utf-8'), 10000) != 0:
        print("Matching timeout")
    else:
        read_line(logreader_dll)

    # Read past logs
    print("Move to 10000ms before")
    logreader_dll.MoveToFormerLineByTime(10000)
    read_line(logreader_dll)

    # Read newest log
    print("Move to newest log")
    logreader_dll.MoveToNewestLine()
    read_line(logreader_dll)

    # Search to past log with regular expression
    print("Search log before")
    key_string = r".*"
    logreader_dll.SearchFormerLog(key_string.encode('utf-8'))
    read_line(logreader_dll)

    logreader_dll.StopLogStoring()
