﻿# -*- coding: utf-8 -*-
from HACDllDriver import factory, CaptureMode

import sys

"""
開発機の HID 操作を記録し、python スクリプトとして出力するサンプルです。
TargetManager にて対象開発機へ接続した状態で、InputDirector を起動してから実行する必要があります。
操作記録に対応したデバイスは、開発機本体に接続された JoyCon(L)、JoyCon(R)、Switch Pro コントローラー、 デバッグパッド、
開発機搭載のタッチスクリーン、ホスト PC に接続された XInput 対応のゲームパッドです。
出力されたスクリプトを実行するためには、HACDllDriver.py を同ディレクトリへ配置しておかなければなりません。
"""

if __name__ == "__main__":
    # sys.argv[1] = 対象のシリアルナンバー
    serial_number = None
    if len(sys.argv) != 1:
        serial_number = sys.argv[1]

    with factory(target_serial=serial_number, capture_device_id=None, capture_mode=CaptureMode.CaptureMode_720p) as driver:
        # 記録開始
        driver.start_hid_record()
        # 入力待ち
        print("Recording hid input: \n(Press enter to finish.)\n")
        sys.stdin.readline()
        # 記録終了
        driver.end_hid_record()
        # スクリプト出力
        driver.export_hid_record("RecordedInput.py")
