﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

uniform sampler2D uTexture0;
uniform sampler2D uTexture1;
uniform sampler2D uTexture2;

layout(location = 0) out vec4 o_Color;

layout(std140) uniform uConstantBufferForPixelShader
{
    vec4 uInterpolateWidth;
    vec4 uInterpolateOffset;
    vec4 uIndirectMtx0;
    vec4 uIndirectMtx1;
    mat4 uVertexColorPsh;
    int uTextureMode;
    int uColorEffectMode;
    vec2 uPadding0;
    // ここから下へユーザーシェーダーで使用する変数を定義する。
    // ここから下で定義した変数のサイズに応じてピクセルシェーダーのユーザーシェーダーコンスタントバッファのサイズを指定する。
    vec4 uUserShaderColor;
    float uTime;
    float uDistortion;
};

layout(location = 0) in vec4 vColor;
layout(location = 1) in vec4 vTexCoord[3];

#include "ui2d_PixelShaderCommonHeader.glsl"

const float PI = 3.14159265;

void main(void)
{
    vec4 color = texture(uTexture0, vec2(vTexCoord[0].s + sin(vTexCoord[0].t * 2.0 * PI * 8.0) * uDistortion, vTexCoord[0].t - uTime * 0.5)) * uUserShaderColor;

    // 頂点カラーの有効無効のシェーダーバリエーション作成。
    // NW_VERTEX_COLOR_ENABLED は ShaderConverter でコンバート時に ui2d_ArchiveShaderVariation.xml に基づいて
    // 自動的に有効/無効のバリエーションが定義される。
#if NW_VERTEX_COLOR_ENABLED
    color *= vColor;
#endif

    o_Color = color;
}

