﻿. $RunSampleScript

function RunSampleAll()
{
    Param
    (
        $BuildVersionList,
        $PlatformList,
        $TargetList,
        $SampleNameList
    )
    
    $PSVersionTable

    $SuccessCount = 0
    $FailureCount = 0

    foreach($BuildVersionLocal in $BuildVersionList)
    {
        foreach($PlatformLocal in $PlatformList)
        {
            foreach($TargetLocal in $TargetList)
            {
                foreach($SampleNameLocal in $SampleNameList)
                {
                    $isSuccess = RunSample $SampleNameLocal $PlatformLocal $BuildVersionLocal $TargetLocal

                    if ( $isSuccess -eq $True )
                    {
                        Write-Host "[OK!!]" -ForegroundColor Green
                        $SuccessCount += 1
                    }
                    else
                    {
                        Write-Host "[..NG]" -ForegroundColor Red
                        $FailureCount += 1
                    }
                }
            }
        }
    }

    if ($FailureCount -ne 0)
    {
        Write-Host "[OK] " $SuccessCount -ForegroundColor Green -NoNewLine
        Write-Host " [NG] " $FailureCount -ForegroundColor Red
    }
    else
    {
        Write-Host "[OK] " $SuccessCount "[NG] " $FailureCount -ForegroundColor Green
    }
}
