﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>

namespace nns { namespace display0 {

//-----------------------------------------------------------------------------
//  IDisplay0DriverSample クラス
//-----------------------------------------------------------------------------

class Display0DriverSample
{
private:
    nn::os::ThreadType      m_Thread;
    nn::os::SystemEventType m_SystemEvent;
    bool                    m_SystemEventAvailable;
    bool                    m_FinalizeRequest;

public:
    Display0DriverSample() NN_NOEXCEPT : m_SystemEventAvailable(false), m_FinalizeRequest(false) {}

    static void ThreadFunc(void* arg) NN_NOEXCEPT;
    void Initialize(nn::os::NativeHandle handle, bool isManaged) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    bool GetFinalizeRequest() const NN_NOEXCEPT
    {
        return m_FinalizeRequest;
    }
};

//-----------------------------------------------------------------------------

}}  // namespace nns::display0

