﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nns/dbgui/dbgui_DefaultUpdateScissorCallbacks.h>

#include <nn/gfx/util/gfx_ScalableViewport.h>

namespace nns { namespace dbgui {


void UpdateScissorScalableViewport(
    nn::gfx::ScissorStateInfo* pScissorStateInfo,
    void* pScalableViewportAsVoid)
{
    nn::gfx::util::ScalableViewport* pScalableViewport =
        reinterpret_cast<nn::gfx::util::ScalableViewport*>(pScalableViewportAsVoid);

    nn::gfx::util::ScalableViewport::Rect virtualRect;
    pScalableViewport->SetupRectFromScissorStateInfo(&virtualRect, *pScissorStateInfo);

    nn::gfx::util::ScalableViewport::Rect physicalRect;
    pScalableViewport->ConvertRectVirtualToPhysical(
        &physicalRect, virtualRect);

    pScalableViewport->SetupScissorStateInfo(pScissorStateInfo, physicalRect);
}


void UpdateScissorInvertYAxis(
    nn::gfx::ScissorStateInfo* pScissorStateInfo,
    void* pViewportHeightAsVoid)
{
    int viewportHeight = *reinterpret_cast<int*>(pViewportHeightAsVoid);

    int originY = pScissorStateInfo->GetOriginY();
    int height = pScissorStateInfo->GetHeight();

    originY = (viewportHeight - originY - height);

    pScissorStateInfo->SetOriginY(originY);
}


} } // namespace nns { namespace dbgui {
