﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"

// タイトル画面
class SceneScanning : public BaseScene
{

public :
    SceneScanning(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
private :
    static void ScanThreadFunc(void* arg) NN_NOEXCEPT;

private :
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE * 12);
    static const int MY_INITIAL_Y = INITIAL_Y + (FONT_SIZE * 10);

    // テキストアニメーション用変数
    static const int TEXT_ANM_STR_LEN = 10;
    int m_animCnt;
    char m_animStr[TEXT_ANM_STR_LEN];
    nn::os::Tick m_prevTick;

    // スキャン用スレッド
    nn::os::ThreadType m_scanThread;
    static nn::os::EventType m_event;
};
