﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nifm/nifm_Api.h>
#include <nn/nifm/nifm_ApiCommunicationControlForTest.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_ApiPrivate.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/wlan/wlan_InfraApi.h>
#include "Async.h"
#include "Command.h"
#include "InteractiveShell.h"


namespace
{

nn::socket::SystemConfigDefaultWithMemory<10, 10> g_SocketConfig;

}


// エントリポイント
extern "C"
void nnMain()
{
    // 無線テストのための初期化
    nn::socket::Initialize(g_SocketConfig);
    Async::Initialize();

    nn::nifm::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::SetWirelessCommunicationEnabledForTest(false));
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(2));

    nn::wlan::InitializeInfraManager();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::Infra::OpenMode());

    InteractiveShell::Initialize();

#ifdef DIRECT_EXECUTION
    const char* commands[] = {
        "help",
        // "join xxx yyy zzz",
        "join PSG-2096bgw wep 73757065726D6172696F727067",
        "socket 192.168.21.1 80",
        "info 1",
//        "",
        "close 1",
        "disconnect",
    };
    for (int i = 0; i < sizeof(commands) / sizeof(commands[0]); ++i)
    {
        char buffer[256] = {};
        std::strcpy(buffer, commands[i]);
        if (std::strcmp(buffer, "") == 0)
        {
            InteractiveShell::Run([](char** argV, int argC) {
                // コマンド実行
                Command::Invoke(argV, argC);
            });
        }
        else
        {
            char* argV[16] ={};
            int argC;

            InteractiveShell::ParseCommandline(argV, &argC, buffer);
            Command::Invoke(argV, argC);
        }
    }
#else
    InteractiveShell::Run([](char** argV, int argC) {
        // コマンド実行
        Command::Invoke(argV, argC);
    });
#endif

    InteractiveShell::Finalize();

    // 無線テストの終了
    nn::wlan::Infra::CloseMode();
    nn::wlan::FinalizeInfraManager();

    nn::nifm::SetWirelessCommunicationEnabledForTest(true);

    Async::Finalize();
    nn::socket::Finalize();
}
