﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Tester.h"

namespace WlanTest {

using namespace std;

const char* TestParam::ITEM_STR_TEST_TIME         = "TEST_TIME";
const char* TestParam::ITEM_STR_TEST_MARGIN       = "TEST_MARGIN";
const char* TestParam::ITEM_STR_MIN_TX_RATE       = "MIN_TX_RATE";
const char* TestParam::ITEM_STR_MIN_RX_RATE       = "MIN_RX_RATE";
const char* TestParam::ITEM_STR_MAX_PLR           = "MAX_PLR";
const char* TestParam::ITEM_STR_MAX_LATENCY_MAX   = "MAX_LATENCY_MAX";
const char* TestParam::ITEM_STR_MAX_LATENCY_AVG   = "MAX_LATENCY_AVG";
const char* TestParam::ITEM_STR_WLAN_MODE         = "WLAN_MODE";
const char* TestParam::ITEM_STR_TX_START_DELAY    = "TX_START_DELAY";

TestResult ToTestResult(bool isSuccess)
{
    return isSuccess ? RESULT_SUCCESS : RESULT_FAILURE;
}

TestResult operator&(const TestResult& t1, const TestResult& t2)
{
    if( t1 == RESULT_NOT_COMPLETED ) return t2;
    if( t2 == RESULT_NOT_COMPLETED ) return t1;
    if( t1 == RESULT_FAILURE || t2 == RESULT_FAILURE ) return RESULT_FAILURE;
    return RESULT_SUCCESS;
}

TestResult operator|(const TestResult& t1, const TestResult& t2)
{
    if( t1 == RESULT_NOT_COMPLETED ) return t2;
    if( t2 == RESULT_NOT_COMPLETED ) return t1;
    if( t1 == RESULT_SUCCESS || t2 == RESULT_SUCCESS ) return RESULT_SUCCESS;
    return RESULT_FAILURE;
}

TestResult& operator&=(TestResult& t1, const TestResult& t2)
{
    t1 = t1 & t2;
    return t1;
}

TestResult& operator|=(TestResult& t1, const TestResult& t2)
{
    t1 = t1 | t2;
    return t1;
}

}
