﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Delegate.h"
#include "WlanCommon.h"

namespace WlanTest {

void Sleep(nn::TimeSpan time);

class Timer
{
/*---------------------------------------------------------------------------
　　　　　静的変数
---------------------------------------------------------------------------*/
public:
private:

/*---------------------------------------------------------------------------
　　　　　静的メソッド
---------------------------------------------------------------------------*/
public:
private:

    static void ThreadFunction(void* arg);

/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:

    nn::TimeSpan Interval;

protected:
private:

    nn::os::TimerEvent timer;
    bool stop;
    nn::os::ThreadType thread;
    nn::TimeSpan stopTime;
    IEventHandler* handler;

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    virtual nn::Result Start(int32_t priority = nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()));
    virtual nn::Result Start(nn::TimeSpan time, int32_t priority = nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()));
    virtual void Stop();

protected:
private:


/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:

    Timer();
    virtual ~Timer();

private:

/*---------------------------------------------------------------------------
　　　　　アクセッサ
---------------------------------------------------------------------------*/
public:

    void SetEventHandler(IEventHandler& handler)
    {
        this->handler = &handler;
    }
};

}
