﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TextWriter.h"
#include "CardWriter.h"

using namespace std;

namespace WlanTest {

class PacketLogger
{

private:

    static PacketLogger*  m_pLogger;
    static bool m_IsEnabled;

    CardWriter* m_pCardWriter;
    TimeWriter* m_pTimeWriter;

private:

    PacketLogger(const PacketLogger&);
    PacketLogger& operator=(const PacketLogger&);

    PacketLogger();
    virtual ~PacketLogger();

public:

    static PacketLogger& GetInstance();

    bool Initialize(const string& dirPath = "", const string& fileName = "");
    void Finalize();
    bool Write(const string& str);

    static void EnableLog();
    static void DisableLog();
    static bool IsEnabled();

};


} // WlanTest
