﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>
#include <cstring>
#include <string>

#include <nn/os/os_Mutex.h>

#include "LcsSocket.h"
#include "Master.h"
#include "Util.h"

namespace WlanTest {

/*!--------------------------------------------------------------------------*
  @brief        LCS Masterクラス
 *---------------------------------------------------------------------------*/

class LcsMaster : public Master
{
/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:

    LcsSocket    m_Socket;

    enum L3State
    {
        State_NotAssigned = 0x00,
        State_Assigning,
        State_Assigned
    };

    struct ClientL3Status
    {
        string ipAddress;
        L3State state;
    };

    ClientL3Status m_ClientL3Status[nn::wlan::ConnectableClientsCountMax];

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    virtual nn::Result Initialize();
    virtual nn::Result Finalize();
    virtual nn::Result Open();
    virtual nn::Result Close();
    virtual void MaintainConnection();
    virtual void StopMaintainConnection();
    virtual nn::Result Disconnect( const nn::wlan::DisconnectClient* pClient );
    virtual nn::Result Disconnect();

    virtual nn::Result WlanGetFrame( uint32_t rxId, uint8_t pOutput[], size_t* pSize, size_t maxSize, int8_t* pRssi = NULL );

    virtual nn::Result Send(uint8_t data[], size_t size, uint8_t ieInd, size_t* pSentSize);
    virtual nn::Result Receive(uint8_t pOutput[], size_t* pSize, const size_t maxSize);

    virtual nn::Result StartReceiveCommand(int32_t priority = nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()))
    { return Node::StartReceiveCommand(priority); }
    virtual nn::Result StopReceiveCommand()
    { return Node::StopReceiveCommand(); }

    virtual bool IsConnected();

    void UpdateLastTxStats() { m_Socket.UpdateLastTxStats(); }
    void UpdateLastRxStats() { m_Socket.UpdateLastRxStats(); }

protected:

    void UpdateL3Status();
    void AssignIpAddress(const int& id);
    void ReassignIpAddress(const int& id);
    void RemoveIpAddress(const int& id);

private:

/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:

    LcsMaster();
    NN_IMPLICIT LcsMaster(nn::wlan::MasterBssParameters param);
    virtual ~LcsMaster();

private:

/*---------------------------------------------------------------------------
　　　　　アクセッサ
---------------------------------------------------------------------------*/
public:

    LcsSocket* GetSocket() { return &m_Socket; }
};


}
